;+
; W_MK_STDIM
;	Widget interface for MK_STDIM
;
; Keywords:
;	group	long	input	Group leader for the heirarchy.
;
; History:
;	Original: 26/3/96; SJT
;-

pro Stdim_event, event

common Stdim_wid, textid, isave_std, icentre

widget_control, event.id, get_uvalue = but

case but of
    'CANCEL': begin
        widget_control, event.top, /destroy
    end
    
    'DO': begin
        widget_control, textid, get_value = txt
        widget_control, event.top, /hourglass
        
        fname = txt(0)
        if (strpos(fname, '.') eq -1) then fname = fname+'.fts'
        mk_stdim, fname, save = isave_std, $
          centre_pick = icentre
        
        widget_control, event.top, /destroy
    end
    
    'SAVE': isave_std = event.select
    
    'CENTRE': icentre = event.select
    Else:
endcase

end

pro W_mk_stdim, group=group

@wload.com

common Stdim_wid, textid, isave_std, icentre

if (xregistered('stdim')) then return ; Ensure only one copy.

if (n_elements(isave_std) eq 0) then isave_std = 0
if (n_elements(icentre) eq 0) then icentre = 0

irenorm = ld.net

base = widget_base(/column, title = 'LASCO Standard image')

junk = widget_label(base, value = 'LASCO Standard image')

jb = widget_base(base, /row)
jkb = widget_base(jb, /column)
jbb = widget_base(jkb, /row)
junk = widget_label(jbb, value = 'Name:')
textid = widget_text(jbb, /edit, value = 'stdim.fts', uvalue = 'STDIM', $
                     xsize = 25)

jb2 = widget_base(jb, /nonexclusive, /column)
junk = widget_button(jb2, value = 'Save File', uvalue = 'SAVE')
widget_control, junk, set_button = isave_std
junk = widget_button(jb2, value = 'Manual Centre?', uvalue = 'CENTRE')
widget_control, junk, set_button = icentre

jbb = widget_base(jkb, /row)
junk = widget_button(jbb, value = 'Cancel', uvalue = 'CANCEL')
junk = widget_button(jbb, value = 'Do it', uvalue = 'DO')

widget_control, base, /real
xmanager, 'stdim', base, group = group

end
