;+
; W_LAS_EXP_NORM
;	WIdget interface for LAS_EXP_NORM
;
; History:
;	Original: 26/3/96; SJT
;-

pro Las_exp_event, event

@chandle.com

common Las_exp_wid, fileid, dirid, storeid, use_mem, store_it, $
  use_all, wdir

widget_control, event.id, get_uvalue = but

case but of
    'CANCEL': widget_control, event.top, /destroy
    
    'DO': begin
        widget_control, event.top, /hourglass
        
        widget_control, fileid, get_value = txt
        fname = txt(0)
        if (strpos(fname, '.') eq -1) then fname = fname+'.fts'
        
        if (not use_mem) then begin
            widget_control, dirid, get_value = txt
            fname = txt(0)+!Delimiter+fname
        endif
        
        las_exp_norm, fname, all = use_all, store = store_it, $
          use_in_mem = use_mem
        
        widget_control, event.top, /destroy
    end
    
    'LIST': begin
        widget_control, fileid, set_value = string_name(event.index)
        use_mem = 1
        store_it = 0
        widget_control, storeid, set_button = 0, sensitive = 0
        widget_control, dirid, set_value = ''
    end
    
    'FILE': begin
        use_mem = 0
        widget_control, storeid, /sensitive
    end
    'DIR': begin
        use_mem = 0
        widget_control, storeid, /sensitive
    end
    
    'PICK': begin
        widget_control, dirid, get_value = txt
        d0 = txt(0)
        if (d0 eq '') then d0 = wdir
        
        fname = pickfile(path = d0, filter = '*.fts', /must, title = $
                         'Calibration Image', get_path = d1)
        fname = strmid(fname, strlen(d1), strlen(fname))
        widget_control, dirid, set_value = d1
        widget_control, fileid, set_value = fname
        use_mem = 0
        widget_control, storeid, /sensitive
    end
       
    'STORE': store_it = event.select
    
    'ALL': use_all = event.select
endcase
        
end


pro W_las_exp_norm, group=group

common Las_exp_wid, fileid, dirid, storeid, use_mem, store_it, $
  use_all, wdir

@chandle.com

if (xregistered('las_exp')) then return ; prevent second copy

wdir = GETENV('WORK')+GETENV('USER')+!Delimiter+ 'fits'+!Delimiter
IF chk_dir(wdir) EQ 0 THEN wdir = ''

if (N_elements(use_mem) eq 0) then use_mem = 0
if (n_elements(store_it) eq 0) then store_it = 0
if (n_elements(use_all) eq 0) then use_all = 0

base = widget_base(/column, title = 'LASCO Normalize exposures')
junk = widget_label(base, value = 'LASCO Normalize exposures')

base1 = widget_base(base, /row)

jb = widget_base(base1, /column, /frame)

junk = widget_label(jb, value = 'Disk choices')

jbb = widget_base(jb, /row)
junk = widget_label(jbb, value = 'File:')
fileid = widget_text(jbb, /edit, value = '', uvalue = 'FILE',  xsize = 25)
junk = widget_button(jbb, value = 'Pick...', uvalue = 'PICK')

jbb = widget_base(jb, /row)
junk = widget_label(jbb, value = 'Directory:')
dirid = widget_text(jbb, /edit, value = '', uvalue = 'DIR', xsize = 30)

jbb = widget_base(jb, /row, /nonexclusive)
storeid = widget_button(jbb, value = 'Store image', uvalue = 'STORE')
widget_control, storeid, set_button = store_it, sensitive = (use_mem $
                                                             eq 0)

junk = widget_button(jbb, value = 'Normalize all', uvalue = 'ALL')
widget_control, junk, set_button = use_all

;================

jb = widget_base(base1, /column, /frame)
junk = widget_label(jb, value = 'Memory Choices')
junk = widget_list(jb, value = string_name, uvalue = 'LIST', ysize = $
                   n_elements(string_name) < 10)


;================

jb = widget_base(base, /row)

junk = widget_button(jb, value = 'Cancel', uvalue = 'CANCEL')
junk = widget_button(jb, value = 'Do it', uvalue = 'DO')

widget_control, base, /real

xmanager, 'las_exp', base, group = group

end
