function Fractile, x, frac

;+
; FRACTILE
;	Return the requested fractile of the input data.
;
; Usage:
;	fr = fractile(x, frac)
;
; Return:
;	fr	<input>	The requested fractile.
;
; Arguments:
;	x	most	input	The array whose fractile(s) are to be
;				returned 
;	frac	float	input	The fractile(s) to return.
;
; Restrictions:
;	The input data must be a SORTable array (i.e. not complex,
;	string or structure).
;
; Example:
;	To find the interquartile range of a data set, try:
;	q = fractile(data, [.25,.75])
;	iqr = q(1)-q(0)
;	
; History:
;	Original: 26/9/95; SJT
;-

if (n_params() ne 2) then message, 'Incorrect number of arguments'

n = n_elements(x)
i = sort(x)

f = round(frac*n)

return, x(i(f))

end
