function Find_mode, data, plotit=plotit

;+
; FIND_MODE
;	Make an estimate of the mode of a dataset.
;
; Usage:
;	mode=find_mode(data[, plotit=plotit])
;
; Return value:
;	mode	float	An estimate of the mode of the dataset.
;
; Argument:
;	data	(float)	input	The data whose mode is needed.
;
; Keyword:
;	plotit	??	input	If set then make a plot of the data &
;				the fit.
;
; Method:
;	2-step process:
;	1) - Find the maximum of a coarse histogram of the data (100
;            bins) other than the "zero" point (this is to deal with
;            missing blocks)
;       2) - make a finer histogram around the value from step 1 and
;            fit a gaussian to it. The peak of the gaussian is then
;            the mode returned.
;
; Restrictions:
;	Conceptually this was developed to fix up the exposures on
;	LASCO ratio images where the mode should ideally be 1 and
;	where the histogram of the image is sharply peaked. It does
;	however appear to work OK for "raw" images.
;
; History:
;	Original: 7/1/96; SJT
;-


mn = min(data, max = mx)
nbin = 100.

hg = histogram(data, min = mn, max = mx, bin = (mx-mn)/nbin)

dmd1 = max(hg(1:*), imd)
imd = imd+1

md1 = imd *(mx-mn)/nbin + mn

mn1 = (imd-2) * (mx-mn)/nbin + mn
mx1 = (imd+2) * (mx-mn)/nbin + mn

hg = histogram(data, min = mn1, max = mx1, bin = (mx1-mn1)/nbin)
x = (findgen(nbin)+.5) * (mx1-mn1) / (nbin) + mn1
x = (findgen(nbin)+.5) * (mx1-mn1) / (nbin) + mn1

hgf = las_fit_gauss(x, hg(0:nbin-1), cff)

if (keyword_set(plotit)) then begin
    plot, x, hg, /ylog
    oplot, x, hgf
    plots, replicate(cff(1), 2), 10^!y.crange
endif

return, cff(1)

end

