function Cc0, im1, im2, mask=mask

;+
; CC0 - cross correlation at zero offset of 2 images.
;-

if (keyword_set(mask)) then begin
    locs = where(mask)
    mean1 = total(im1(locs))/n_elements(locs)
    mean2 = total(im2(locs))/n_elements(locs)

    return, total((im1(locs)-mean1)*(im2(locs)-mean2))/ $
      sqrt(total((im1(locs)-mean1)^2)*total((im2(locs)-mean2)^2))
    
endif else begin
    mean1 = total(im1)/n_elements(im1)
    mean2 = total(im2)/n_elements(im2)

    return, total((im1-mean1)*(im2-mean2))/ $
      sqrt(total((im1-mean1)^2)*total((im2-mean2)^2))
endelse

end
