;+
; W_STDIM_LIST
;	A widget interface for MK_STDIM_LIST
;-

pro Lsi_get_text_wids

common Sdt_list_wid, ccg, cexp, cfilt, cpol, cpix, cdir, cdark, $
  cinter, cupper, csave, cclev, cslev, ccent, cname, $
  filters, polars, fbases, expid, szid, ulid, corid, satid, dkid, $
  fileid, fids

for j = 0, 1 do begin
    widget_control, expid(j), get_value = jtxt
    cexp(j) = float(jtxt(0))
    
    widget_control, szid(j), get_value = jtxt
    cpix(j) = fix(jtxt(0))
    
    widget_control, ulid(j), get_value = jtxt
    cupper(j) = fix(jtxt(0))
endfor

widget_control, fileid, get_value = cname
cname = cname(0)
widget_control, corid, get_value = cclev
cclev = cclev(0)
widget_control, satid, get_value = cslev
cslev = cslev(0)
widget_control, dkid, get_value = cdark
cdark = cdark(0)

end

pro Std_list_event, event

common Sdt_list_wid, ccg, cexp, cfilt, cpol, cpix, cdir, cdark, $
  cinter, cupper, csave, cclev, cslev, ccent, cname, $
  filters, polars, fbases, expid, szid, ulid, corid, satid, dkid, $
  fileid, fids

widget_control, event.id, get_uvalue = sender

case sender of
    'CANCEL': widget_control, event.top, /destroy
    
    'LIST': begin
        lsi_get_text_wids
        if (strpos(cname, '.lst')) eq -1 then begin
            ifts = rstrpos(cname, 'fts')
            if (ifts eq -1) then lfile = cname+'.lst' $
            else lfile = strmid(cname, 0, ifts)+'lst'
        endif
        widget_control, event.top, /hourglass
        junk = mk_list(coronagraph = ccg, exposure = cexp, filter = $
          filters(cfilt, ccg-1), polarizer = polars(cpol), $
          pixels = cpix, upper_left = cupper, lfile)
        widget_control, event.top, /destroy
    end
    
    'DO': begin
        lsi_get_text_wids
        widget_control, event.top, /hourglass
        mk_stdim_list, cname, coronagraph = ccg, exposure = cexp, $
          filter = filters(cfilt, ccg-1), polarizer = polars(cpol), $
          pixels = cpix, upper_left = cupper, save = csave, clevel = $
          cclev, interact = cinter, dark = cdark, slevel = cslev, $
          centre = ccent
        widget_control, event.top, /destroy
    end
        
    'CORONAGRAPH': begin
        for j = 0, 2 do widget_control, fbases(j), map = j eq event.value
        widget_control, dkid, set_value = ([322, 470, $
                                            319])(event.value)
        if (event.value+1 ne ccg) then widget_control, $
          fids(event.value), get_value = cfilt
        ccg = event.value+1
    end
    'FILTER': cfilt = event.value
    'POLAR': cpol = event.value
    
    'IC': case (event.value) of
        'Interact': cinter = event.select
        'Centre': ccent = event.select
    end
    
    Else:                       ; Throw away other events
endcase

end

pro W_stdim_list, group=group

common Sdt_list_wid, ccg, cexp, cfilt, cpol, cpix, cdir, cdark, $
  cinter, cupper, csave, cclev, cslev, ccent, cname, $
  filters, polars, fbases, expid, szid, ulid, corid, satid, dkid, $
  fileid, fids

if (xregistered('std_list')) then return ; No duplicates

;		Establish default settings

if (n_elements(ccg) eq 0) then ccg = 1
if (n_elements(cexp) eq 0) then cexp = [0., 3600.]
if (n_elements(cfilt) eq 0) then cfilt = 0
if (n_elements(cpol) eq 0) then cpol = 0
if (n_elements(cdark) eq 0) then case ccg of
    1: cdark = 322
    2: cdark = 470
    3: cdark = 319
end
if (n_elements(cinter) eq 0) then cinter = 0
if (n_elements(cpix) eq 0) then begin
    if (ccg eq 1) then begin
        cpix = [832, 672]
        cupper = [115, 193]
    endif else begin
        cpix = [1024, 1024]
        cupper = [20, 1]
    endelse
endif
if (n_elements(csave) eq 0) then csave = 1
if (n_elements(cclev) eq 0) then cclev = 0.0
if (n_elements(cslev) eq 0) then cslev = 16383
if (n_elements(ccent) eq 0) then ccent = 1
if (n_elements(cname) eq 0) then cname = 'stdim.fts'

filters = [['Fe XIV', 'Fe X', 'Ca XV', 'Na I', 'Orange'], $
           ['Orange', 'Blue', 'H alp', 'DeepRd', 'Lens'], $
           ['Clear', 'Orange', 'Blue', 'DeepRd', 'IR']]

polars = ['Clear', '0 Deg', '+60 De', '-60 De']


base = widget_base(title = 'Standard Image Generation', /column)

junk = widget_label(base, value = 'LASCO Standard images')

jb1 = widget_base(base, /row, /frame)


;		COLUMN1 Coronagraph, filter & Polarizer.

jb = widget_base(jb1, /column)

junk = cw_bselector2(jb, ['C1', 'C2', 'C3'], label_left = $
                    'Coronagraph:', /return_index, set_value = ccg-1, $
                    uvalue = 'CORONAGRAPH')

pb = widget_base(jb)
fbases = lonarr(3)
fids = lonarr(3)
for j = 0, 2 do begin
    fbases(j) = widget_base(pb, /row)
    if (j eq 0) then flabl = 'Fabry-Perot:' else flabl = 'Filter:'
    fids(j) = cw_bselector2(fbases(j), filters(*, j), label_left = flabl, $
                        /return_index, set_value = cfilt, uvalue = $
                        'FILTER')
    widget_control, fbases(j), map = j eq (ccg-1)
endfor

junk = cw_bselector2(jb, polars, label_left = 'Polarizer', $
                    /return_index, set_value = cpol, uvalue = 'POLAR')

;		COLUMN2 exposure & Size

jb = widget_base(jb1, /column)

jjb = widget_base(jb, /column, /frame)
junk = widget_label(jjb, value = 'Exposure range')

jjbb = widget_base(jjb, /row)
expid = lonarr(2)
for j = 0, 1 do $
  expid(j) = widget_text(jjbb, /edit, value =  $
                         string(cexp(j), format = "(F6.1)"), xsize = 8, $
                         uvalue = 'CAN')

jjb = widget_base(jb, /column, /frame)
junk = widget_label(jjb, value = 'Image Size')

jjbb = widget_base(jjb, /row)
szid = lonarr(2)
for j = 0, 1 do $
  szid(j) = widget_text(jjbb, /edit, value =  $
                        string(cpix(j), format = "(I4)"), xsize = 8, $
                        uvalue = 'CAN')

jjb = widget_base(jb, /column, /frame)
junk = widget_label(jjb, value = 'Image Corner')

jjbb = widget_base(jjb, /row)
ulid = lonarr(2)
for j = 0, 1 do $
  ulid(j) = widget_text(jjbb, /edit, value =  $
                        string(cupper(j), format = "(I4)"), xsize = 8, $
                        uvalue = 'CAN')

;		COLUMN 3 Details

jb = widget_base(jb1, /column)

fileid = cw_field(jb, value = cname, title = 'Name:', uvalue = 'NAME', $
                  xsize = 16)

junk = cw_bgroup(jb, ['Interact', 'Centre'], /return_name, /row, $
                 uvalue = 'IC', /nonexclusive, set_value = [cinter, $
                                                             ccent])

corid = cw_field(jb, value = cclev, /float, title = 'Min Correlation', $
                 xsize = 10, uvalue = 'CORR')

satid =  cw_field(jb, value = cslev, /long, title = 'Saturation', $
                 xsize = 10, uvalue = 'SAT')

dkid = cw_field(jb, value = cdark, /int, title = 'Dark Current', xsize $
                = 5, uvalue = 'DARK')

;		Across the bottom: DO & Cancel

jb = widget_base(base, /row)

junk = widget_button(jb, value = 'Cancel', uvalue = 'CANCEL')
junk = widget_button(jb, value = 'Make List', uvalue = 'LIST')
junk = widget_button(jb, value = '   Do It   ', uvalue = 'DO')


;		Realize & manage

widget_control, base, /real

xmanager, 'std_list', base, group = group

end
