pro Mk_stdim_hdr, head, last_head, image, filename, nim, $
                  rebinned=rebinned, no_stats=no_stats

;+
; MK_STDIM_HDR
;	Make the fits header for a standard image.
;
; Usage:
;	mk_stdim_hdr, head, last_head
;
; Arguments:
;	head	string	in/out	The header to be updated - must be
;                                                          derived
;                                                          from the
;                                                          first image
;                                                          of the set
;                                                          if it is to
;                                                          work
;                                                          properly
;	last_head str	input	The header of the last image of the
;				set.
;	image	float	input	The standard image to be described by
;				the header
;	filename string	input	The name of the file to include in the
;				header.
;	nim	int	input	The number of images incorporated.
;
; Keyword:
;	rebin	???	input	If set & non-zero, then the image may
;				have been rebinned if it was a
;				low-resolution image.
;
;
; Effects:
;	The FITS header is updated.
;
; History:
;	Original: 4/6/96; SJT
;-

s = size(image)

sxaddpar, head, 'EXPTIME', 1.0  ; Normalization
sxaddpar, head, 'BITPIX', -32   ; FLoating-point
if (keyword_set(rebinned)) then begin
    sxaddpar, head, 'SUMROW', 1 ; Set SUMROW & SUMCOL to 1 as we don't
    sxaddpar, head, 'SUMCOL', 1 ; want to enlarge the image again when
                                ; we re-read it
endif
sxaddpar, head, 'NAXIS1', s(1)
sxaddpar, head, 'NAXIS2', s(2)

sxaddpar, head, 'FILENAME', filename

date_end = sxpar(last_head, 'DATE-OBS')+" "+sxpar(last_head, $
                                                  'TIME-OBS')
sxaddpar, head, 'DATE_END', date_end
sxaddpar, head, 'DATAMIN', min(image, max = mx)
sxaddpar, head, 'DATAMAX', mx

junk = where(image eq 0, nzer)
sxaddpar, head, 'DATAZER', nzer

sd = stdev(image, imgav)
sxaddpar, head, 'DATAAVG', imgav
sxaddpar, head, 'DATASIG', sd

ptcs = [1, 10, 25, 75, 98, 99]
dpk = string(ptcs, format = "('DATAP',I2.2)")
if (keyword_set(no_stats)) then for j = 0, n_elements(ptcs)-1 do $
  sxdelpar, head, dpk(j) $
else begin  
    fls = fractile(image, ptcs/100.)
    for j = 0, n_elements(ptcs)-1 do sxaddpar, head, dpk(j), fls(j)
endelse

dt = systime(1) + 3.7869120d+08 ; Convert from 1970.0 to 1958.0
tm = tai2utc(dt, /ccsds)
sxaddpar, head, 'DATE', tm


sxaddpar, head, 'HISTORY', "Normalization file from " + $
	string(nim,format="(I0)") + " input files"


end
