pro Las_auto_exp

;+
; LAS_AUTO_EXP
;	Do a "bootstrap" exposure correction to the currently selected
;	images.
;
; Usage:
;	las_auto_exp
;
; Arguments & Keywords: None
;
; Method:
;	This routine make use of the 64x64 block in the centre of the
;	occulting disk which is now normally transmitted. It is
;	assumed that this retains a constant brightness. It is further
;	assumed that the exposures are correct on average.
;
; Restrictions:
; 	It is assumed that the images have been corrected for offset
; 	bias and nominal exposure and that this is a fine adjustment.
;
; History:
;	Original: 1/10/96; SJT
;-

@chandle.com
@wload.com

od_bright, corfac, bias, expc

for j = 0, n_elements(sel_array)-1 do if (corfac(j) ne 1.0) then begin
    ghandle, sel_array(j)
    
    print, j, sel_array(j), '  ', name
    imt = image
    expt = sxpar(head, 'EXPTIME')
    offb = offset_bias(strtrim(sxpar(head, 'DETECTOR')), $
                       strtrim(sxpar(head, 'READPORT')))

    if (expc(j) and not bias(j)) then imt = imt - offb/expt $
    else if (bias(j) and not expc(j)) then imt = imt/expt $
    else if (not bias(j) and not expc(j)) then imt = (imt - $
                                                       offb)/expt
    
    image = imt / corfac(j)
    
    sxaddpar, head, 'EXPTIME', expt * corfac(j), 'Was: '+string(expt)
    sxaddpar, head, 'HISTORY', "Exposure tweaked by LAS_AUTO_EXP"
    
    handle_value, h_array(sel_array(j)), image, /set
    handle_value, h_head(sel_array(j)), head, /set
endif

end
