;+
; W_POLY_DIFFIM
;	Widget interface for POLY_DIFFIM
;
; History:
;	Original: 26/3/96; SJT
;-

pro Diffim_event, event

@chandle.com
common Diffim_wid, imgno, new_old, tid, inorm, dobut, cosmic, sum_fix

widget_control, event.id, get_uvalue = but

case but of
    'CANCEL': widget_control, event.top, /destroy
    
    'DO': begin
        widget_control, event.top, /hourglass
        
        poly_diffim, imgno, in_place = new_old, divide = inorm, $
          cr_mask = cosmic, fix_sum = sum_fix
        
        widget_control, event.top, /destroy
    end
    
    'OVER':new_old = event.value
    'NORM': inorm = event.value
    'COSMIC': cosmic = event.value
    'SUM': sum_fix = event.value
    
    'LIST': begin
        imgno = event.index
        widget_control, tid, set_value = string_name(imgno)
        widget_control, dobut, /sensitive
    end
endcase

end

pro W_poly_diffim, group=group

@chandle.com
common Diffim_wid, imgno, new_old, tid, inorm, dobut, cosmic, sum_fix

if (xregistered('diffim')) then return ; Only 1 copy

if (n_elements(new_old) eq 0) then new_old = 0
if (n_elements(inorm) eq 0) then inorm=0
if (n_elements(cosmic) eq 0) then cosmic = 0

base = widget_base(/column, title = 'LASCO Image differences')

junk = widget_label(base, value = 'LASCO Image differences')

bbase = widget_base(base, column = 2)
junk = cw_bselector2(bbase, ['New Images', 'In Place'], /return_index, $
                    uvalue = 'OVER', set_value = new_old)
junk = cw_bselector2(bbase, ['Subtract', 'Divide', 'Divide - 1'], $
                    /return_index, uvalue = 'NORM', set_value = inorm)
junk = cw_bselector2(bbase, ['No filtering', 'CR Filter'], $
                    /return_index, uvalue = 'COSMIC', set_value = cosmic)
junk = cw_bselector2(bbase, ['No sum fix', 'Fix summing'], $
                    /return_index, uvalue = 'SUM', set_value = sum_fix)

junk = widget_list(base, value = string_name, uvalue = 'LIST', ysize = $
                   n_elements(string_name) < 16)

tid = widget_text(base, value = '')

jb = widget_base(base, /row)
junk = widget_button(jb, value = 'Cancel', uvalue = 'CANCEL')
dobut = widget_button(jb, value = '   Do it   ', uvalue = 'DO')
widget_control, dobut, sensitive = 0

widget_control, base, /real
xmanager, 'diffim', base, group = group

end
