pro Exp_norm_event, event

common Las_exp_fix, criterion, overw

widget_control, event.id, get_uvalue = but

case (but) of
    'DONT': widget_control, event.top, /destroy
    
    'DO': begin
        widget_control, event.top, /hourglass
        exp_norm, new = overw, mode = criterion
        widget_control, event.top, /destroy
    end
    
    'CRIT': criterion = event.value
    'OW': overw = event.value
endcase

end

pro W_exp_norm, group=group

common Las_exp_fix, criterion, overw

if (xregistered('exp_norm')) then return ; no duplicates

if (n_elements(criterion) eq 0) then criterion = 0
if (n_elements(overw) eq 0) then overw = 1

base = widget_base(/column, title = 'LASCO Exposures', group = group)

junk = widget_label(base, value = 'Exposure fixing')


junk = cw_bselector2(base, ['Use Median', 'Use Mode'], label_left = $
                    'Criterion:', uvalue = 'CRIT', set_value = $
                    criterion)
junk = cw_bselector2(base, ['Replace images', 'Make new images'], $
                    label_left = 'Overwrite?:', uvalue = 'OW', $
                    set_value = overw)  

jb = widget_base(base, /row)

junk = widget_button(jb, value = '   Cancel   ', uvalue = 'DONT')
junk = widget_button(jb, value = '    Do it    ', uvalue = 'DO')

widget_control, base, /real

xmanager, 'exp_norm', base

end
