pro Od_bright, bright, bias, expc, nominal=nominal

;+
; OD_BRIGHT
;	Determine the brightness of the central block in the occulting
;	disk, and also estimate whether the image has been bias
;	subtracted and/or exposure corrected.
;
; Usage:
;	od_bright, bright, bias, expc
;	
; Arguments:
;	bright	float	output	The relative brightness of the
;				occulting disk block
;	bias	byte	output	Estimate of whether the bias has been
;				subtracted (Assumes that if the image
;				has any part < 3/4 of the bias
;				[corrected by exposure if needed] then
;				the bias has been removed).
;	expc	byte	output	Estimate of whether the image has been
;				exposure corrected (assumes that if
;				the maximum of the image multiplied
;				by the exposure exceeds the saturation
;				value of 16383 then the image has NOT
;				been exposure-normalized).
;
; Restrictions:
;	It is possible that "on-board summed" images may confuse the
;	EXPC determination.
;
; History:
;	Original: 1/10/96; SJT
;	Try median instead of masked mean: 7/11/96; SJT
;-

@wload.com
@chandle.com

bright = fltarr(n_elements(sel_array))
bias = bytarr(n_elements(sel_array))
expc = bytarr(n_elements(sel_array))
nominal = fltarr(n_elements(sel_array))

sbr = 0. & nbr = 0

for j = 0, n_elements(sel_array)-1 do begin
    ghandle, sel_array(j)
    
    tel = strtrim(sxpar(head, 'DETECTOR'), 2)
    
;;    case tel of
;;        'C1': corner = [480, 448] - [sxpar(head, 'R1COL') - 21, $
;;                                     sxpar(head, 'R1ROW') - 1]
;;        'C2': corner = [480, 480]- [sxpar(head, 'R1COL') - 20, $
;;                                    sxpar(head, 'R1ROW') - 1]
;;        'C3': corner = [480, 512]- [sxpar(head, 'R1COL') - 20, $
;;                                    sxpar(head, 'R1ROW') - 1]
;;    endcase
    offb = offset_bias(tel, strtrim(sxpar(head, 'READPORT')))
    ext = sxpar(head, 'EXPTIME')
    nominal(j) = ext
    
    mi = min(image, max = mx)
    expc(j) = mx * ext le 16383.
    if (expc(j)) then bias(j) = (mi lt offb*.75/ext) $
    else bias(j) = (mi lt offb*.75)

;;    blim = image(corner(0):corner(0)+63, corner(1):corner(1)+63)
;;    mask = sigma_mask(blim, 15, n_sigma = 4., /all, outbox = 3)
    
    if (bias(j) and not expc(j)) then blim = image / ext $
    else if (expc(j) and not bias(j)) then blim = image - offb/ext $
    else if (not expc(j) and not bias(j)) then blim = (image - offb)/ext
    
;;    mask = reform(mask, 32, 2, 32, 2)
;;    blim = reform(blim, 32, 2, 32, 2)
    
;;    br = total(total(blim, 3), 1)
;;    locs = where(br gt 0, nok)
;;    if (nok ne 4) then begin
;;        message, /cont, "++ W A R N I N G ++ missing blocks from OD " + $
;;          "patch"
;;        print, br
;;    endif
;;    if (nok ne 0) then begin
;;        bright(j) = median(blim)
;;        sbr = sbr+bright(j)
;;        nbr = nbr+1
;;    endif else bright(j) = 0.0
    bright(j) = median(image)
    
    print, j, sel_array(j), name, bright(j), bias(j), expc(j), $
      format = "(2I4,2x,a,2x,f12.5,2i2)
endfor

;;sbr = sbr/float(nbr)
;;bright = bright/sbr
locs = where(bright gt 0., nok)
if (nok gt 0) then bright = bright * nok / total(bright(locs))
locs = where(bright le 0, nn)
if (nn ne 0) then bright(locs) = 1.0

return

end
