function min_nz, array, mindex, max=max

;+
; MIN_NZ
;	Extract the smallest positive element of an array.
;
; Call:
;	val = min_nz(array[, mindex, max=max])
;
; Return Value:
;	val	any	The smallest positive value or -1 if no positive
;			values.
;
; Argument:
;	array	any	input	The array whose min is needed
;	mindex	long	output	The (first) location in the array at
;				which the min value is found.
;
; Keyword:
;	max	any	output	The maximum value in the array.
;
; History:
;	Prototype: 24/1/91; SJT
;	Improve and changes to smallest >0: 22/2/91; SJT
;	Add MAX keyword: 31/3/92; SJT
;	Add optional second argument for location of min value:
;							20/8/93; SJT
;	Add "finite" condition: 6/12/93; SJT
;-

locs = where(array gt 0 and finite(array))
if (locs(0) eq -1) then begin
    mindex = -1
    minv = -1l
endif else begin
    minv = min(array(locs), mindex, max=max)
    mindex = locs(mindex)
endelse

return, minv

end
