pro ssw_start_rpcserver, cgidir=cgidir, serverid, _extra=_extra, $
   interactive=interactive, idl_dir=idl_dir, save_script=save_script, $
   no_execute=no_execute, $
   path_http=path_http, top_http=top_http, $
   new_idlstartup=new_idlstartup
;
;+
;   Name: ssw_start_rpcserver
;
;   Purpose: start an ssw-idl rpc server
;
;   Input Parameters:
;      serverid - desired rpc server id - default = 2010CAFE
;                 if supplied via string of length 4, then '2010'SERVERID is assumed
;
;   Keyword Parameters:
;      cgidir - path to desired cgi
;      interactive - if set, ask user for some parameters 
;      idl_dir - desired IDL_DIR for server (def=$IDL_DIR or /usr/local/rsi/idl)
;      save_script - if set, save the startup as a script
;      _EXTRA - optional list of ssw instruments/packages to include in server environment
;               (default from current $SSW_INSTR list)
;     no_execute=no_execute - do not actually start the created script
;     save_script - if set, save the CSH script to $SSW/site/setup/
;                   filename='setup.<host>_server_<serverid>'
;     path_http - path (local NFS name) to top of desired WWW tree (default=$path_http)
;     top_http  - associated URL pointing to PATH_HTTP
;                 (note path_http and top_http are local vs remote WWW synonyms)
;
;   Calling Examples:
;      ssw_start_rpcserver, 'CAFA', idl_dir='/usr/local/rsi/idl_6.1'
;      ssw_start_rpcserver,/interactive 
;      
;   Restrictions:
;      if cgidir is supplied (string or switch), user must have cgi-bin write access.
;      assumes idlRPC client exists for this OS/ARCH (in $SSW_PACKAGES/...)
;
;   History:
;      23-March-2005 - S.L.Freeland - simplify user setup of ssw/cosec servers
;
;   Method:
;      Create implied startup script and launchit
;
;-
runnit=1-keyword_set(no_execute)
if not data_chk(serverid,/string) then serverid='2010CAFE'  ; rsi/ssw default

server=(['','2010'])(strlen(serverid) eq 4)+serverid

user=get_user()
host=get_host(/short)

rpcclient=ssw_bin('idlRpcClient',found=found)

if not found then begin 
   box_message,'Sorry, only works for OS/ARCH with existing rpc client in SSW/packages/binaries..'
   return
endif
rpccl=ssw_strsplit(rpcclient,'/',/tail,/last,head=binpath)

; 
pr_status,status 
header=['#!/bin/csh -f','# ' + status]
scmds=header

osarch=get_infox(!version,'os,arch',del='_')
; make the script
;
; 1. search for existing and corresponding server and kill if present
case 1 of
   is_member(osarch,'darwin_ppc'): begin
      pscmd="ps -uww "+user+ " | grep idlrpc | grep "+serverid
      pidloc=2   ; unix CSH location of PID
   endcase
   else: begin 
   endcase
endcase

if n_elements(pscmd) gt 0 then begin 
   scmds=[header,'set psrpc=`'+pscmd+'`',$
      'if ("$psrpc" != "") then', '   kill -9 $psrpc['+strtrim(pidloc,2)+']','endif' ] 
endif else box_message,'Do not yet know ps command for this OS yet for auto-kill (continuing..)


; setup server $SSW_INSTR
ssw=get_logenv('SSW')   ; local top of $SSW tree

if data_chk(_extra,/struct) then begin 
   box_message,'Assuming inherited keywords defined desired $SSW_INSTR list for server
   sint=strlowcase(arr2str(_extra,' '))
endif else sint=get_logenv('SSW_INSTR')  ; current user values
sint=strtrim(sint,2)
sswsetup=['setenv SSW ' + get_logenv('SSW'), $
          'setenv SSW_INSTR "' + sint + '"',        $
          'source '+ concat_dir(ssw,'gen/setup/setup.ssw') ]

scmds=[scmds,sswsetup] 

eidldir=get_logenv('IDL_DIR')
case 1 of 
   data_chk(idl_dir,/string): idldir=idl_dir
   eidldir ne '': idldir=eidldir
   else: begin
      toprsi='/usr/local/rsi'
      idls=file_list(toprsi,['idl','idl_*'])
      idldir=last_nelem(idls)
   endcase
endcase


servid4=strmids(serverid,strlen(serverid)-4,4)
logfile=concat_dir('$SSW_SITE_LOGS',host+'_server_'+servid4+'.log')
idlrpc='idlrpc -server='+server + ' > ' +logfile + ' &'

startname='ssw_server_init_'+host+'_'+servid4
idlstart=(concat_dir('$SSW_SITE_SETUP',startname))(0) + '.pro'


scmds=[scmds,'setenv IDL_DIR '+idldir(0)]
;scmds=[scmds,'setenv IDL_STARTUP ' + idlstart(0)]
scmds=[scmds,'setenv IDL_PATH ' + $                  ; set sswidl server
          '+'  + concat_dir('$SSW','site/idl') + $   ; bootup path
          ':+' + concat_dir('$SSW','gen/idl')  + $
          ':'  + get_logenv('SSW_SITE_SETUP')  + $
          ':+' + concat_dir(idldir(0),'pro')     ]           
scmds=[scmds,idlrpc]

; generate IDL STARTUP for This server...
newstart=not file_exist(idlstart) or keyword_set(new_idlstartup)

if newstart then begin 
   if data_chk(path_http,/string) then phttp=path_http else $
      phttp=get_logenv('path_http')
   if data_chk(top_http,/string) then thttp=top_http(0) else $
      thttp=get_logenv('top_http')
   pr_status,status,/idldoc,/caller
   status=[status,';','; IDLRPC Server Startup',$
           '; HOST: ' + host + ' SERVERID: ' + server]
   file_append,idlstart,'pro ' + startname,/new
   sswpath='ssw_path'+ arr2str(str2arr(' '+sint,' '),',/')
   file_append,idlstart,[status,sswpath]
   file_append,idlstart,"set_plot,'z'"
   file_append,idlstart,'set_logenv,"path_http","'+phttp+'"'
   file_append,idlstart,'set_logenv,"top_http","'+thttp+'"'
   file_append,idlstart,'end'

endif else box_message,'Not regenerating IDL startup for this server'

if data_chk(cgidir,/string) then cmddir=cgidir else cmddir=binpath
rpccmd='./idlRpcClient 0x'+server+' '+ host+ ' '
scmds=[scmds,'sleep 30','cd ' + cmddir,rpccmd+startname]
cshscript='setup.'+host+'_'+server+'_' + servid4
save_script=keyword_set(save_script) or (1-file_exist(cshscript))
if save_script then file_append,cshscript,scmds,/new
if runnit then spawn,'csh -f '+cshscript+ ' &',out
box_message,out
 

end;
