
;+

pro hsi_pixon_plot_residuals, mprofile, dobj, residuals, snr_sigma2, $
                              a2d, harmonics,poisson=poisson, bobj=bobj, $
                              NORM_NOZERO=NORM_NOZERO

;NAME:
;     HSI_PIXON_PLOT_RESIDUALS
;PURPOSE:
;     Plot residuals during the pixon image reconstruction
;CATEGORY:
;CALLING SEQUENCE:
;     hsi_pixon_plot_residuals, mprofile, dobj,residuals, snr_signa2, $
;                               a2d,harmonics,/poisson
;INPUTS:
;     mprofile = modulation profile for the current image
;     dobj = data structure from hsi_pixon_get_data
;     bobj = background data structure from hsi_pixon_get_data
;     residuals = mprofile-data (only used if poisson is NOT set)
;     snr_sigma2 = noise (only used if poisson is NOT set)
;     a2d = list of a2d's currently in use
;     harmonics = list of harmonics for each a2d
;     /poisson = use Poisson statistics instead of Gaussian statistics
;	  NORM_NOZERO = normalize by the number of positive profile values, not the number of
;		data bins, ie. dropouts should be ignored
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;OUTPUTS:
;     Just makes a plot in the current window
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 1999-Dec-15
;	  3-may-2010, richard.schwartz@nasa.gov, added nrnozero to hsi_pixon_gof_calc
;	 10-may-2010, richard.schwartz@nasa.gov, NORM_NOZERO keyword, default is to use nrnozero
;		otherwise, number of data bins regardless of expectation value, that was the default
;		behavior until 10-may-2010

;-

   default, NORM_NOZERO, 1
   na2d = n_elements(a2d)
   i1 = 0L

   psave = !p.multi
   !p.multi = [0,1,na2d,1,1]

   if keyword_set(poisson) then gofstring=' C: ' else gofstring=' CHI^2: '

   for i=0L,na2d-1L do begin
      h = *harmonics[i]
      nh = n_elements(h)
      for j = 0,nh-1 do begin
         fobs = *dobj[a2d[i],h[j]]
         bgnd = *bobj[a2d[i],h[j]]
         nfobs = n_elements(fobs)
         m = mprofile[i1:i1+nfobs-1L]
         if NOT keyword_set(poisson) then begin
            r = residuals[i1:i1+nfobs-1L]
            s = snr_sigma2[i1:i1+nfobs-1L]
         endif
         if j EQ 0 then begin
            ; Only plot the first harmonic, cause I'm too lazy to do this right
            gof = hsi_pixon_gof_calc(fobs,m,r,s,poisson=poisson,nresid=nresid, norm_nozero=norm_nozero)
            gof = f_div(gof, nresid)
            plot,fobs,charsize=2.0,xstyle=1,/nodata, $
               title=strcompress('DET: '+string(a2d[i]+1)+gofstring+string(gof))
            oplot,fobs,color=!d.table_size/2
            oplot,bgnd,color=fix(3.*!d.table_size/4.)
            oplot,m
         endif
         i1 = i1 + nfobs
      endfor
   endfor

   !p.multi = psave

end
