;take care of the case where arg2 is 0, arg1 always gt 0
function alog_1, arg1, arg2
p2 = where( arg2 gt 0, np2)
z2 = where( arg2 eq 0, nz2)
out  = arg1
if nz2 ge 1 then out[z2] = alog(arg1[z2])
if np2 ge 1 then out[p2] = alog(arg1[p2]/arg2[p2])
return, out
end
;+

function hsi_pixon_gof_calc,data,recon_data,residuals,snr_sigma2,r2s, $
                            poisson=poisson,iobj=iobj,dobj=dobj, $
                            a2d=a2d,harmonics=harmonics,setunits=setunits, $
                            nresiduals=nresiduals, norm_nozero=norm_nozero

;NAME:
;     HSI_PIXON_GOF_CALC
;PURPOSE:
;     Calculates the goodness of fit parameter for the Pixon reconstruction.
;     Uses either Poisson or Gaussian statistics.
;CATEGORY:
;CALLING SEQUENCE:
;     gof = hsi_pixon_gof_calc(data,recon_data,residuals,snr_sigma2,r2s,/poisson)
;INPUTS:
;     data = data vector
;     recon_data = modulation profile for the current image
;     residuals = mprofile-data (only used if poisson is NOT set)
;     snr_sigma2 = noise (only used if poisson is NOT set)
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;OUTPUTS:
;     gof = goodness of fit parameter
;     r2s = vector for use in the gradient calculations, only computed if the
;           parameter is present, so if you don't need it, don't include it
;	  nresiduals - number of non-zero expectation values, used to normalize/reduce the stat
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 1999-Dec-15
;     T. Metcalf 2002-Jan-03 Added a check for negative recon_data when
;                            /poisson is set.
;	  3-may-2010, richard.schwartz@nasa.gov, added nresiduals
;	6-oct-2010, richard.schwartz@nasa.gov, use c_statistic.pro
;-

rnozero = where(recon_data GT 0.0,nrnozero)
nresiduals = keyword_set(norm_nozero) ? nrnozero : n_elements(data)
   if keyword_set(poisson) then begin
	gof = c_statistic( data, recon_data, nn=nresiduals)
	gof = gof*nresiduals
;;      ; There seem to be some cases where the recon data can be slightly
;;      ; negative.  This should not be the case, but check for it here.
;;
;;
;;      ;dnozero = where(data GT 0.0 AND recon_data GT 0.0,ndnozero)
;;      ;dnozero = where( recon_data GT 0.0,ndnozero)
;;      ;dnozero = where(data GT 0.1 AND recon_data GT 0.0,ndnozero)   ; Ignore the dropouts
;;
      if n_params() GE 5 then begin
         ; Assume a perfect fit if recon_data LE 0.0 (i.e r2s=0)
         r2s = make_array(size=size(recon_data),value=0.0)
         if nrnozero GT 0 then $
            r2s[rnozero] = 2.0*(1.-data[rnozero]/recon_data[rnozero])
      endif
;;      ; logterm tends to zero as data goes to zero so account for this
;;      logterm =  make_array(size=size(recon_data),value=0.0)
;;      if nrnozero GT 0 then $
;;         logterm[rnozero] = data[rnozero]*alog_1(recon_data[rnozero],data[rnozero])
;;
;;      ; What I derived for HXT, which now appears to be wrong ...
;;      ;;if n_params() GE 5 then r2s = alog(recon_data/data)
;;      ;;gof = total(data - recon_data + recon_data*alog(recon_data/data))
;;      ; What Ed Schmahl derived from the Cash paper (ApJ, 228, 939, 1979)
;;      gof = -2.0*total(data - recon_data + logterm)
;;
;;      if NOT finite(gof) then begin
;;         message,'ERROR: GOF is not finite.'
;;      endif
;;      ;gof = -2.0*total(data_good - recon_data_good + $
;;      ;                 data_good*alog(recon_data_good/data_good))
   endif else begin
      if n_params() GE 5 then r2s = 2.0*residuals*snr_sigma2
      gof = total(snr_sigma2*(residuals^2))
   endelse

   return,gof

end
