
;+

function hsi_pixon_get_data, iobj, $
	 nodropout=nodropout, $
	 harmonics=harmonics, a2dindex=a2d, $
	 dflat=data, sigma=sigma,nounits=nounits,bobj=bobj,bflat=bgrnd,snr=snr

;NAME:
;     HSI_GET_DATA
;PURPOSE:
;     Returns a vector of count rates corrected for live time from a CE object
;CATEGORY:
;CALLING SEQUENCE:
;     data = hsi_pixon_get_data(object)
;INPUTS:
;OPTIONAL INPUT PARAMETERS:
;
;KEYWORD PARAMETERS
;     a2dindex = Returns with a list of valid a2d's
;     harmonics = Returns with an array of pointers which point to a list
;                 of valid harmonics for each a2d.
;     dflat = returns with data as a 1-d array
;     sigma = sigma as 1-D array
;     btot = Returns with a very crude estimate of the total counts in the
;            image.  Come to think if it, it is completely wrong.
;            Use hsi_btot.pro instead.
;     /nounits = do not fix the units to counts/second.  Leave as counts.
;	  NODROPOUT - total number of non-zero livetime data points
;OUTPUTS:
;     data = array of pointers to data
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 1999-November 12
;     2007-May-21 TRM new harmonic scheme
;	4-may-2010, richard.schwartz@nasa.gov added NODROPOUT
;-


   time_bin = float(iobj->get(/time_bin_def)*iobj->get(/time_bin_min))/2L^20
   a2d = [-1]
   harmonics = [ptr_new()]

   celist = iobj->GetData(class_name='hsi_calib_eventlist')
   scelist  = size(celist)
   dobj = ptrarr(scelist[1],1)  ; in the new scheme, there is no harmonic index
   bobj = ptrarr(scelist[1],1)

   first = 1
   nodropout = 0

   for i=0,scelist[1]-1 do begin  ; Is this the right order???
      htemp = [0]  ; no harmonic index in the new scheme
      j = 0 ; no harmonic index in the new scheme
      if ptr_valid(celist[i,j]) then begin
         a2d = squeeze([a2d,i])
         stemp = (*celist[i,j]).count

         if keyword_set(nounits) then units = 1.0 $
         else begin
            qtrans = (*celist[i,j]).gridtran
            units = time_bin[i MOD 9] * (*celist[i,j]).livetime
         endelse

         ; Calculate and set background
         btemp = (*celist[i,j]).background
         dropout = where((*celist[i,j]).livetime LT 0.001,ndropout)
         if ndropout GT 0 then btemp[dropout] = 0.
         nodropout = n_elements(stemp)-ndropout+nodropout

         ;dtemp = stemp/units
         ;stemp = sqrt(stemp>1.)/units
         dtemp = f_div(stemp,units)
         btemp = f_div(btemp,units)
         stemp = f_div(sqrt(stemp>1.),units)


         if first then begin
            data = [dtemp]
            sigma = [stemp]
            bgrnd = [btemp]
            first = 0
         endif else begin
            data = [data,dtemp]
            sigma = [sigma,stemp]
            bgrnd = [bgrnd,btemp]
         endelse
         dobj[i,j] = ptr_new(dtemp)
         bobj[i,j] = ptr_new(btemp)
      endif
      harmonics = [harmonics,ptr_new(htemp)]
   endfor

   if n_elements(a2d) GT 1 then begin
      a2d = a2d[1:*]
      harmonics = harmonics[1:*]
   endif

   ; fit sine waves to the data to model the background
   ;if keyword_set(snr AND 4) AND NOT iobj->get(/use_flux_var) then $
   ;   bobj = hsi_pixon_fit_bgrnd(data,iobj,bobj,dobj,celist,a2d,harmonics, $
   ;                              /positive,/nooffset)

   return,dobj

end
