  
;+

pro hsi_pixon_free_mem,nogc=nogc

;NAME:
;     HSI_PIXON_FREE_MEM
;PURPOSE:
;     Frees the memory used to store the smoothed modulation patterns
;CATEGORY:
;CALLING SEQUENCE:
;     hsi_pixon_free_mem
;INPUTS:
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS:
;     /nogc = Do not do the final garbage collection
;OUTPUTS:
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;     Also does a garbage collection.
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 2001-Feb-21
;     2001-Mar-06  Added call to heap_gc
;-

; if this common block is change, it must also be changed in
; hsi_pixon_broj.pro

common hsi_pixon_bproj_private,units,smoothed_patterns,save_pixon_sizes,npixons,savempd

   if n_elements(smoothed_patterns) GT 0 then begin
      if NOT keyword_set(quiet) then $
         message,/info,'Freeing old smoothed_patterns array'
      for i=0L,n_elements(smoothed_patterns)-1L do begin
         if ptr_valid(smoothed_patterns[i]) then begin
            for j=0L,n_tags(*smoothed_patterns[i])-1L do begin
               if ptr_valid((*smoothed_patterns[i]).(j)) then $
                   ptr_free,(*smoothed_patterns[i]).(j)
            endfor
            ptr_free,smoothed_patterns[i]
         endif
      endfor
   endif 
   if NOT keyword_set(nogc) then begin
      if NOT keyword_set(quiet) then $
         message,/info,'Doing a garbage collection'
      heap_gc
   endif

end
