function hsi_pixon_geterrcalc,error,residual,sigma,dobj,iobj,this_a2d,this_harmonic,nxy
; Error calculation for a single a2d & harmonic
; This routine is used by hsi_pixon_geterrcalc (below) and should not be called
; except through that program
;
; T. Metcalf 2000-Jan-10

   checkvar,nbins,100L  ; Isn't this in some object field?
   ndah = n_elements(residual)
   if n_elements(*dobj[this_a2d,this_harmonic]) NE ndah then $
      message,'data and vrate have incompatible dimensions'
   ndah1 = ndah-1L
   i1 = 0L
   REPEAT begin
      i2 = (i1+nbins-1L)<(ndah1)
      ndat = i2-i1+1L
      mp = iobj->GetModulPattern(this_a2d,this_harmonic,i1,i2)
      rbig =transpose(rebin(residual[i1:i2],ndat,nxy)) 
      sbig =transpose(rebin(sigma[i1:i2],ndat,nxy)) 
      btemp = total(((mp*rebin(error,nxy,ndat) + rbig)/sbig)^2,2)
      if n_elements(bproj) LE 0 then begin
         bproj = btemp
      endif else begin
         bproj = bproj + btemp
      endelse
      i1 = i1 + nbins
   endrep UNTIL i1 GE ndah

   return,bproj

end

;+

function hsi_pixon_error_calc,dobj,iobj,error,image,residual,sigma,a2d,harmonics,setunits=setunits,useunits=useunits

;NAME:
;     HSI_PIXON_ERROR_CALC
;PURPOSE:
;     Get an error image for a HESSI image reconstruction
;CATEGORY:
;CALLING SEQUENCE:
;     error = hsi_pixon_error_calc(dobj,iobj,error,residual,sigma,a2d,harmonics
;INPUTS:
;     dobj = data object
;     iobj = CE object
;     error = estimate of the error (see hsi_image_error.pro)
;     residual = residuals of data
;     sigma = sigma for each data
;     a2d = list of a2d's (from hsi_pixon_get_data.pro)
;     harmonics = list of harmonics's for each a2d 
;                 (from hsi_pixon_get_data.pro)
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;OUTPUTS:
;     error = error image
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 2000-Jan-10
;-

   common hsi_pixon_error_calc_private,units

   if n_elements(units) LE 0 or keyword_set(setunits) then begin
      message,/info,'Resetting units'
      if n_elements(units) GT 0 then ptr_free,units
      ;celist = iobj->getcalibeventlist()
      celist = iobj->GetData(class_name='hsi_calib_eventlist')
      scelist = size(celist)
      units = ptrarr(scelist[1])
      time_bin = float(iobj->get(/time_bin_def)*iobj->get(/time_bin_min))/2L^20
      for i=0,scelist[1]-1 do begin  ; Is this the right order???
         ;for j=0,scelist[2]-1 do begin
            if ptr_valid(celist[i,0]) then begin
               qtrans = (*celist[i,0]).gridtran
               units[i] = $
                  ptr_new(time_bin[i MOD 9] * (*celist[i,0]).livetime)
            endif
         ;endfor
      endfor
   endif


   ;image_dim = iobj->Get(/image_dim)
   ;nx = long(image_dim[0])
   ;ny = long(image_dim[1])
   ;nxy = nx*ny
   szimage = size(image)
   nx = szimage[1]
   ny = szimage[2]
   nxy = nx*ny
   i1 = 0L
   for i=0,n_elements(a2d)-1 do begin 
      nharmonics = n_elements(*harmonics[i])
      for j=0,nharmonics-1 do begin
         ndah = n_elements(*dobj[a2d[i],(*harmonics[i])[j]])
         i2 = i1 + ndah -1L
         if keyword_set(useunits) then $
            unit = (*units[a2d[i],(*harmonics[i])[j]]) $
         else $
            unit = 1.0
         btemp = hsi_pixon_geterrcalc(reform(error,nxy), $
                                      residual[i1:i2]/unit, $
                                      sigma[i1:i2]/unit, $
                                      dobj, $
                                      iobj, $
                                      a2d[i], $
                                     (*harmonics[i])[j], $
                                      nxy)
         i1 = i1 + ndah
         if n_elements(bproj) LE 0 then begin
            bproj = btemp
         endif else begin
            bproj = bproj+btemp
         endelse
      endfor
   endfor

   if i2 NE n_elements(residual)-1 then message,'residual had the wrong dimension'

   return,bproj

end


