;+
; PROJECT:
;       HESSI
;
; NAME:
;       HSI_PIXON_CONTROL__DEFINE
;
; PURPOSE:
;       Defines the data structure for the pixon control parameters
;
; CATEGORY:
;       Imaging
;
; CALLING SEQUENCE:
;       struct = {hsi_pixon_control}
;
; TAG NAMES:
;
;       resolution
;       snr
;       guess
;       pixon_sizes
;       sensitivity
;       smpattwritedir
;
; SEE ALSO:
;       hsi_pixon_control
;       hsi_pixon__define
;
; HISTORY:
;       T. Metcalf 20001 Feb 27
; Modificatoins:
;   22-May-2001, Kim.  Added progress_bar parameter.
;   16-Mar-2004, TRM Added calc_pmap, background_model, and
;                variable_metric parameters.
;-
;

PRO HSI_Pixon_control__define

struct =  {HSI_Pixon_Control, $
           resolution: 0L, $
           snr: 0, $
           background_model: 0, $
           variable_metric: 0, $
           full_pm_calc: 0, $
           guess: ptr_new(), $
           pixon_sizes: ptr_new(), $
           sensitivity: 0.0, $
           noplot: 0, $
           smpattwritedir: '', $
           progress_bar: 1}	;kim


END
