
pro hsi_pixon_calc_bgrnd_fit,x,a,f,pder
   common hsi_pixon_calc_bgrnd_fit_private,spin_period
   ;a[2] = a[2] MOD 2.0*!pi
   sarg = 2.*!pi*x/spin_period+a[2]
   sarg2 = 4.*!pi*x/spin_period+a[4]
   sterm = sin(sarg)
   sterm2 = sin(sarg2)
   f = a[0]+a[1]*sterm+a[3]*sterm2
   if n_params() GE 4 then begin
      pder = fltarr(n_elements(f),n_elements(a))
      pder[*,0] = 1.0
      pder[*,1] = sterm
      pder[*,2] = a[1]*cos(sarg)
      pder[*,3] = sterm2
      pder[*,4] = a[3]*cos(sarg2)
   endif
end

function hsi_pixon_calc_bgrnd, time, data, sigma, spin_periodin, fitcoeff=a

;+
;NAME:
;     hsi_pixon_calc_bgrnd
;PURPOSE:
;     Calculate the RHESSI background that is modulated by the spin
;     period. 
;CATEGORY:
;CALLING SEQUENCE:
;     bgrnd = hsi_pixon_calc_bgrnd(time, data, sigma, spin_period)
;INPUTS:
;     time = array of times (in sec)
;     data = array of counts (same dimension as time)
;     sigma = errors on data
;     spin_period = spin period of spacecraft
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;OUTPUTS:
;     bgrnd = array of background that is modulated by the spin so
;             that the background subtracted data is data-bgrnd
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;     Fits
;     a+b*sin(2*pi*time/spin_period+c)+d*sin(4*pi*time/spin_period+c)
;     for unknowns a,b,c 
;MODIFICATION HISTORY:
;     T. Metcalf 2002-11-05
;-


   common hsi_pixon_calc_bgrnd_fit_private,spin_period

   spin_period = spin_periodin

   ; Fit data to a+b*sin(2*pi*time/spin_period+c) for unknowns a,b,c

   a = [mean(data),1.0,0.0,1.0,0.0]
   if n_elements(sigma) NE n_elements(time) then $
      weights = 1.0+fltarr(n_elements(time)) $
   else weights = 1.0/(sigma^2)

   fit = curvefit(time,data,weights,a,function_name='hsi_pixon_calc_bgrnd_fit')

   return,fit

end



; test
; time = findgen(100)/25. & data = 10.+1.0*sin(2.0*!pi*time/4.0+1.0)
; fit =  hsi_pixon_calc_bgrnd(time, data, 4.0)
