;+
  ; :Name:
  ;   HSI_Pixon_Benchmark
  ; :Description:
  ;    This is a test procedure to both validate the hessi pixon code and report the time
  ;    taken by the pixon algorithm as a function of the total number of pixels in an image
  ; 
  ; :Params:
  ;    time_stat - string description of benchmark, seconds for number of pixels
  ;    img_time
  ; :Keywords:
  ;    obj - image object. May be input or used to extract
  ;    _extra - can be used to set up different time, energy, detector ranges for time benchmarks
  ; :History
  ;   20-jan-2015, written
  ;
  ;
  ; :Author: richard.schwartz@nasa.gov
  ;-

PRO HSI_Pixon_Benchmark, time_stat, img_time, obj = obj, _extra=_extra
  obj = is_class(obj, 'hsi_image') ? obj : hsi_image()
  obj-> set, flatfield= 0
  obj-> set, im_energy_binning= [25.000000D, 50.000000D]
  obj-> set, im_time_interval= ['20-Feb-2002 11:06:00.000', '20-Feb-2002 11:06:43.000']
  obj-> set, image_algorithm= 'Pixon'
  obj-> set, image_dim= [32, 32]
  obj-> set, modpat_skip= 4
  obj-> set, pixel_size= [1.0000, 1.0000]*2, det_index_mask = [0,   0,   1,   1,   1,   1,   1,   1,   0]
  obj-> set, smoothing_time= 4.00000
  obj-> set, time_bin_def= [1.00000, 2.00000, 2.00000, 4.00000, 8.00000, 16.0000, 32.0000, $
    32.0000, 64.0000]
  obj-> set, time_bin_min= 512L
  obj-> set, use_flare_xyoffset= 0
  obj-> set, xyoffset= [904.320, 259.778]
  obj-> set, use_phz_stacker= 1L
  obj-> set, pixon_noplot= 1
  obj-> set, pixon_snr= 8
  obj-> set, pixon_sensitivity= 0.501202
  obj-> Set, _extra = _extra
  
  im = obj->getdata() ;run once to clear overhead
  img_time = fltarr(3)
  time_stat = strarr(3)
  scl = [1., 1.5, 2.0]
  pixon_sensitivity = obj->get(/pixon_sensitivity)
  obj->set, pixon_sensitivity = pixon_sensitivity + .01
  obj->set, pixon_sensitivity = pixon_sensitivity - .01 
  for i=0,2 do begin
    obj-> set, image_dim= [32, 32]*scl[i], pixel_size = [2.0, 2.0]/scl[i], pixon_sens= 0.5011
    obj-> set, pixon_snr = (obj->Get(/pixon_snr) or 8) ;or 2 ;2 is for the full map
    t1 = systime(1) & help, obj->getdata() & img_time[i] = systime(1) - t1
    time_stat[i] = 'Run '+strtrim(i,2)+' takes '+string(img_time[i])+ ' seconds for '+ $
      strtrim( (obj->get(/image_dim))[0]^2, 2)+' total pixels'
    print, time_stat[i]
  endfor
print, 'HSI_Pixon_Benchmark Timing Results: '
print, time_stat, form='(a)'
end