;+
; PROJECT:
;	HESSI
; NAME:
;	HSI_XY2CART_INDEX
;
; PURPOSE:
;	This function returns the CART pixel indices for an arbitrary x and y pair in the FOV.
; CATEGORY:
;	HESSI, IMAGE, UTIL, CARTESIAN
;
; CALLING SEQUENCE:
;
;	indices = hsi_xy2cart_index(x, y, hsi_img_obj)
;
; SAMPLE CALL:
;
;	IDL> print,x,y
;      716.000      723.000      480.000      477.000      600.000
;      321.000      175.000      83.4000      322.000      199.000
;	
; CALLS:
;	HESSI OBJECTS
;
; INPUTS:
;	Map coordinate along X axis in arcseconds from sun center
;	Map coordinate along Y axis in arcseconds from sun center.
;	Hsi_img_obj - object containing calibrated eventlist object.  Should also contain modpat control object.
;	;
;
; OPTIONAL KEYWORD INPUTS:
;
; OUTPUTS:
;	Function returns the pixel coordinate along the x (first index) and y(second index).
;
; OPTIONAL OUTPUTS:
;	none
;
;
; OPTIONAL KEYWORD INPUTS:
;
;	none
; COMMON BLOCKS:
;	none
;
; SIDE EFFECTS:
;	none
;
; RESTRICTIONS:
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	3-jun-2017, ras
;
;-

function hsi_xy2cart_index, x, y, image_obj

;hsi_cart_coord,image_obj, x, y
xyoffset = image_obj->Get( /xyoffset )
pixel_size = image_obj->Get( /pixel_size )
image_dim = image_obj->Get(/image_dim )
xpix  = reform( (pixel_coord( [image_dim[0],1] ))[0,*]) + xyoffset[0]
ypix  = reform( (pixel_coord( [image_dim[1],1] ))[0,*]) + xyoffset[1]
xindex = value_locate( xpix, x[*] )
yindex = value_locate( ypix, y[*] )



return, transpose( [[xindex[*]],[yindex[*]]])
end




