function hsi_square_mpati,   cbe_obj, det_index, $
  rem_gridtran = rem_gridtran, $
  image_dim = image_dim, $
  pixel_size = pixel_size, $
  modpat_only= modpat_only


  twopi = 2.0 * !pi
  default, harmonic, 0
  default, modpat_only, 0
  if size(/tname,cbe_obj) eq 'POINTER' then cbe = cbe_obj else $
    cbe = cbe_obj->getdata( this_det_index=det_index);,$
  ;    this_harmonic=harmonic)
  if size(cbe,/tname) eq 'POINTER' THEN CBE = *CBE[DET_INDEX]
  npat = n_elements(cbe)
  ;Stacks don't have .time field

  ;time_unit = cbe_obj->get(/time_unit)
  ;livetime = chktag(cbe,'time') ? $
  ;    float(cbe.livetime * (cbe[1].time-cbe[0].time) / 2.0^20) * time_unit : $
  ;    cbe.livetime
  ;det_eff = (cbe_obj->get(/cbe_det_eff)).rel
  ;this_det_eff = det_eff[det_index]

  pixel = transpose(hsi_pixel_coord( image_dim )) ;pixel coords in asec  map_dim x 2
  for i=0,1 do pixel[0,i] = pixel[*,i] * pixel_size[i]
  ang_pitch = (hsi_grid_parameters()).pitch
  orient    = (hsi_grid_parameters()).orient
  harm = 1
  default, rem_gridtran, 0

  out = hsi_modul_pattern_compute( /nobyte, $
    cbe, !pi/2-orient[det_index], pixel, ang_pitch[det_index]/harm)
  ;out = hsi_modul_pattern_compute( /nobyte, $
  ;	cbe, orient[det_index], pixel, ang_pitch[det_index]/harm)
  ;if min(out) lt -.001 then stop
  if ~modpat_only then begin
    gridtran = rem_gridtran ? fltarr( npat ) + 1.0 : cbe.gridtran
    gridmod =  cbe.modamp * gridtran
    for i=0,npat-1 do out[*,i] = gridtran[i] + gridmod[i]*out[*,i]
  endif
  return,  reform(out, 1L * image_dim[0] * image_dim[1], npat,/over)
end
;+
; PROJECT:
;   HESSI
; NAME:
;   HSI_SQUARE_MPAT
;
; PURPOSE:
;   This routine builds a cartesian (flat xy) modulation pattern
;   for every time bin for each grid and combines them into a single array
;	This array is the probability of a photon at the mpat energy of passing through
;	the grid originating from a pixel (Xi,Yi) in the FOV
;
; CATEGORY:
;   HESSI, UTIL,
;
; CALLING SEQUENCE:
;   	hsi_square_mpat, obj, sqm, cstr, pxscale=pxscale, effarea=effarea,scale=sqale
;
; CALLS:
;		hsi_modul_pattern_compute, hsi_square_mpati
;
; INPUTS:
;   obj - image object (may pass calib_eventlist object but then must pass the optional inputs describing the fov)
; OPTIONAL INPUTS: obtained from the image object or modpat or profile objects, if a calib_eventlist obj is passed
;	then these arguments must be included.  Ususal meaning for an hsi_image object
;	image_dim = image_dim,
;	pixel_size = pixel_size
;	pixel_scale= pixel_scale

;   none
;
; OUTPUTS:
;   sq_matrix
;	calib_str
;
; Keywords:
;
;	scale = scale, (includes det_eff.rel[k]*time_bin[k]*flux_var[i]*livetime[i]*duration,
;		k index is for grid, i index is for the bin for that grid.
;	pxscale=pxscale  (scale x duration)
;   effarea=effarea  det_eff.avg * 39.51
;	nbins=nbins  number of bins for each grid, starts at finest grid used
;   modpat_only -  if set, return only the energy independent portion of the mpat
;   no_modpat - if set, don't compute the spatial portion of the mpat
;	calib_str_def - 1, or 0 if set, assign calib_str keywords to this structure, tag gridmod is the product of modamp and gridtran
; 		tags used
; rem_gridtran - don't multiply modpats by gridtran term, only modamp
; KEYWORDS:
; COMMON BLOCKS:
;   none
;
; SIDE EFFECTS:
;   none
;
; RESTRICTIONS:
;   none
;
; PROCEDURE:
;   none
;
; MODIFICATION HISTORY:
;	Started 1998,
;	Finished, Feb 2012
;   Updated Dec 2012, added modpat_only, no_modpat, calib_str_def
;	Richard.Schwartz@nasa.gov
;-
pro hsi_square_mpat, obj, sq_matrix, calib_str, $; , det_index_mask=det_index_mask;, harmonic
  image_dim = image_dim, $
  pixel_size = pixel_size, $
  pixel_scale= pixel_scale, $
  scale = scale, pxscale=pxscale ,effarea=effarea, nbins=nbins, $
  modpat_only = modpat_only, $  ;, harmonic
  rem_gridtran = rem_gridtran, $ ;set to make this identical to the bproj probability
  no_modpat = no_modpat, $;modpat (from modpati) are all the same for a set of energies, so only need the first
  calib_str_def = calib_str_def ;If this is set then set calib_str to use gridtran, gridmod (modamp*gridtran), scale
  ;where scale is dt (livetime * time_bin * flux_var)/duration

  ;IF obj_isa(obj,'HSI_IMAGE') then begin
  test = obj->get(/image_dim)
  if test[0] ne -1 then begin
    image_dim = test
    pixel_size = obj->get(/pixel_size)
    pixel_scale = obj->get(/pixel_scale)
  endif
  cobj =  obj->get(/obj,class='hsi_calib_eventlist')
  default, modpat_only, 0
  default, no_modpat, 0
  if not exist(image_dim) or not exist(pixel_size) or not exist(pixel_scale) then $
    message,'Need image obj or modul pattern controls:  image_dim, pixel_size, pixel_scale'
  pixel_size = pixel_size * pixel_scale[0]

  cbeptr= cobj->getdata(); class='hsi_calib_eventlist')
  calib_str = ptr_concat(cbeptr)
  nbin = 0
  s    = where(cobj->get(/det_index_mask),ns)
  nbin = lonarr(ns)
  for i=0,ns-1 do nbin[i] = n_elements(*cbeptr[s[i]])
  ;ci   = *cbeptr[s[ns-1]]
  npix = image_dim
  npix = product( npix )

  nbins = [0,total(nbin, /cum)]

  if ~NO_MODPAT then begin
    sq_matrix = fltarr(total(nbin), npix)
    for i = 0, ns-1 do sq_matrix[nbins[i],0] = $
      transpose( hsi_square_mpati(cobj, s[i], $
      rem_gridtran = rem_gridtran, $
    image_dim = image_dim, pixel_size = pixel_size, modpat_only=modpat_only))
  endif


  ;if n_params() eq 3 then begin
  ;	calib_str = replicate( ci[0], nbins[ns])
  ;	for i=0,ns-1 do calib_str[nbins[i]] = *cbeptr[s[i]]
  ;	endif
  duration = cobj->Get(/absolute_time)
  duration = duration[1]-duration[0]
  scale     = (calib_str.flux_var * calib_str.livetime*1.0) / duration
  ;scale     = ( calib_str.livetime*0.0+1.0) / duration

  ;Use time_bin for time bin size in busec if available
  ;If time_bin undefined, we have to define it if time tag not available
  det_eff  = cobj->Get(/cbe_det_eff)
  time_bin = hsi_get_time_bins(cobj)
  for i=0,ns-1 do $

    scale[nbins[i]] = det_eff.rel[s[i]] * scale[nbins[i]:nbins[i+1]-1] * time_bin[s[i]]/2.0d0^20
  pxscale = scale * duration
  effarea = det_eff.avg * 39.51
  if keyword_set( calib_str_def) then begin
    old = calib_str
    calib_str = replicate( {gridtran: 0.0, gridmod: 0.0, scale: 0.0, $
      count:0.0, livetime:0.0, atten_state:0,flux_var:0.0}, n_elements(old))
    calib_str.gridtran = old.gridtran
    calib_str.gridmod = old.gridtran*old.modamp[0] ;in case of harmonics
    calib_str.scale    = scale
    calib_str.count  = old.count
    calib_str.livetime= old.livetime
    calib_str.atten_state= old.atten_state
    calib_str.flux_var = old.flux_var

  endif
end
