;  11-Apr-2003, Kim.  Added cw_inverse keyword - draws dashed line for inverse boxes
;  7-May-2007, Kim.  Save !p.position and restore at end
;  16-Sep-2008, Kim.  Now check and set up new window for plotting here.

PRO hsi_show_clean_maps, clean_map, resid_map, dirty_map, clbox, $
  ps_model, xy = xy, iter = iter, map_max = map_max, gain = gain, $
  clean_param = clean_param, psf = psf, clean_box_pixels = clean_box_pixels, $
  cw_pixels = cw_pixels, save_cwindow = save_cwindow,  cw_inverse = cw_inverse

  ; displays results of hsi_map_clean
  ; new version feb2001
  ;
  ; sa"m

  if save_cwindow eq -1 or (is_wopen(save_cwindow) eq 0) then begin
    save_cwindow = next_window(/user)
    dwsize_x = clean_param.show_map_xdim
    dwsize_y = dwsize_x/2
    window, save_cwindow, xsize = dwsize_x, ysize = dwsize_y, xpos = 0, ypos = 50, title = 'HSI CLEAN'
  endif

  wset, save_cwindow
  pos_save = !p.position

  ;what is the actual window size
  aws_x = float(!d.x_size)
  aws_y = float(!d.y_size)

  cw_nop = *clean_param.cw_nop
  dim = size( /dimension, dirty_map )
  xdim = dim[0] & ydim = dim[1]
  
  ytext = 20
  ;the Displayed Window Size is
  dws_x = aws_x/4.-ytext
  dws_y = dws_x
  mmin = min(dirty_map)
  mmax = max(dirty_map)
  y2 = 1-0.8*(ytext/aws_y)
  y1 = 0.5-0.8*(ytext/aws_y)
  dx = dws_x/aws_x/2.
  dxx = 1.-(1-8*dx)/2.
  dy = ytext/aws_y
  xw = (aws_x-4.*ytext)/4./aws_x
  xwl = ytext/aws_x
  ;yw = (aws_y-2.*ytext)/2./aws_y
  ;ywl = ytext/aws_y
  yw = xw*aws_x/aws_y
  ywl = (1.-2*yw)/2.

  if (iter le 0) OR $
    ( ((clean_param.more_iter ne 0) AND (clean_param.clean_last_iter+1 ge iter)) OR $
    clean_param.clean_stop eq 'neg maximum' ) then begin
    erase
    hhh = dirty_map
    hhh[0:xdim-1] = mmax
    set_viewport, 0, xw, yw+ywl, 2*yw+ywl
    plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata
    tvscl,  congrid( reform( hhh,  xdim,  ydim ),  dws_x,  dws_y ), 0, aws_y/2.
    hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 0, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

    dy = ytext/aws_y
    XYouts, dx, y2, 'DIRTY map', ali = 0.5, /normal
    XYouts, dx, y1, 'CLEANed map', ali = 0.5, /normal
    XYouts, 3*dx, y2, 'RESIDUAL map', ali = 0.5, /normal
    XYouts, 3*dx, y1, 'scaled RESIDUAL map', ali = 0.5, /normal
    XYouts, 5*dx, y2, 'COMPONENT map', ali = 0.5, /normal
    XYouts, 5*dx, y1, 'scaled COMPONENT map', ali = 0.5, /normal
    XYouts, 7*dx, y2, 'Selected maxima', ali = 0.5, /normal
    XYouts, 7*dx, y1, 'CLEAN components', ali = 0.5, /normal
    XYouts, dxx, 1.-1.4*dy, 'ITERATION:', ali = 0.5, /normal
    XYouts, dxx, 1.-3.4*dy, 'max_resid:', ali = 0.5, /normal
    XYouts, dxx, 1.-5.4*dy, 'max_cl/rms_res', ali = 0.5, /normal
    XYouts, dxx, 1.-7.4*dy, 'max_cl/max_res', ali = 0.5, /normal, charsize = 0.8
    XYouts, dxx, 1.-9.4*dy, 'SUM c comp:', ali = 0.5, /normal, charsize = 0.8
    XYouts, dxx, 1.-11.4*dy, 'gain:', ali = 0.5, /normal
    XYouts, dxx, 1.-12*dy, string(gain), ali = 0.5, /normal

  endif

  ;CLEANed map (bottom)
  set_viewport, 0, xw, 0, yw
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = ((clean_map+resid_map)>mmin)<mmax
  hhh[0:xdim-1] = mmax
  hhh[xdim] = mmin
  tvscl,  congrid( reform( hhh,  xdim,  ydim ),  dws_x,  dws_y ), 0, 0
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 0, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;RESIDUAL map (top)
  set_viewport, xw, 2*xw, yw+ywl, 2*yw+ywl
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = resid_map
  hhh[0:xdim-1] = mmax
  ;hhh[xdim] = mmin
  if keyword_set(xy) then $
    if iter le 5 then hhh[xy] = mmin else hhh[xy] = mmax
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y ), 1*dws_x, aws_y/2.
  ;if iter eq 8 then stop
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 255, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;MAXIMA (top)
  set_viewport, 3*xw, 4*xw, yw+ywl, 2*yw+ywl
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = ps_model<0.01
  hllist = where(clbox eq 0)
  ;if hllist(0) ne -1 then hhh(hllist) = 0.005
  hhh[0:xdim-1] = max(hhh)
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y ), 3*dws_x, aws_y/2.
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 255, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;CONVOLVED CLEAN components (top)
  set_viewport, 2*xw, 3*xw, yw+ywl, 2*yw+ywl
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = clean_map
  hhh[0:xdim-1] = mmax
  hhh[xdim] = mmin
  if keyword_set(xy) then $
    if iter le 5 then hhh[xy] = mmax else hhh[xy] = mmin
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y ), 2*dws_x, aws_y/2.
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 0, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;hhh = clbox
  ;list = where(clbox eq 0)
  ;hhh(list) = hhh(list)+mmin
  ;hhh[0:xdim-1] = mmax
  ;hhh[xdim] = mmin
  ;tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y), 2*dws_x, 0

  ;RESIDUAL map (lower)
  set_viewport, xw, 2*xw, 0, yw
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = resid_map
  ;hmax = max(abs(resid_map))
  ;hhh[0:xdim-1] = hmax
  ;hhh[xdim] = -hmax
  hhh[0:xdim-1] = max(hhh)
  if keyword_set(xy) then hhh[xy] = min(hhh)
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y), 1*dws_x, 0
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 0, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;CONVOLVED CLEAN component (low)
  set_viewport, 2*xw, 3*xw, 0, yw
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = clean_map
  hhh[0:xdim-1] = max(hhh)
  if keyword_set(xy) then $
    if iter le 5 then hhh[xy] = max(hhh) else hhh[xy] = min(hhh)
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y ), 2*dws_x, 0
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 0, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse

  ;clean component (lower)
  set_viewport, 3*xw, 4*xw, 0, yw
  plot, [0, 1], [0, 1], ystyle = 5, xstyle = 5, yr = [0, 1], xr = [0, 1], /nodata, /noe
  hhh = ps_model
  hllist =        where(clbox eq 0)
  ;if hllist(0) ne -1 then hhh(hllist) = max(ps_model)
  hhh[0:xdim-1] = max(hhh)
  tvscl, congrid( reform( hhh, xdim, ydim ), dws_x, dws_y ), 3*dws_x, 0
  hsi_oplot_clean_boxes, clean_box_pixels, xdim, ydim, 255, cw_pixels = cw_pixels, cw_nop = cw_nop, cw_inverse = cw_inverse


  ;display ITERATION
  tvscl, fltarr(4*ytext, 1.5*ytext), 4*dws_x, aws_y-3*ytext
  XYouts, dxx, 1.-2*dy, string(iter+1), ali = 0.5, /normal


  ;display MAX in MAP
  tvscl, fltarr(4*ytext, 1.5*ytext), 4*dws_x, aws_y-5*ytext
  if map_max lt 0 then $
    XYouts, dxx, 1.-4*dy, string(map_max), ali = 0.5, /normal, color = 122 else $
    XYouts, dxx, 1.-4*dy, string(map_max), ali = 0.5, /normal

  ;display signal-to-noise
  tvscl, fltarr(4*ytext, 1.5*ytext), 4*dws_x, aws_y-7*ytext
  ;XYouts, dxx, 1.-6*dy, string(max(clean_map)/max(resid_map)), ali = 0.5, /normal
  XYouts, dxx, 1.-6*dy, string(max(clean_map)/(1*sigma(resid_map))), ali = 0.5, /normal
  tvscl, fltarr(4*ytext, 1.5*ytext), 4*dws_x, aws_y-9*ytext
  XYouts, dxx, 1.-8*dy, string(max(clean_map)/max(resid_map)), ali = 0.5, /normal
  tvscl, fltarr(4*ytext, 1.5*ytext), 4*dws_x, aws_y-11*ytext
  ;  XYouts, dxx, 1.-10*dy, string(total(clean_map)/total(dirty_map)*100.), ali = 0.5, /normal
  ;XYouts, dxx, 1.-10*dy, string(total(ps_model)/max(dirty_map)*100.), ali = 0.5, /normal
  XYouts, dxx, 1.-10*dy, string(total(ps_model)), ali = 0.5, /normal
  ;stop

  ;set_viewport, 0.1, 0.9, 0.1, 0.9
  !p.position = pos_save

END

