;+
;NAME:
;     hsi_pixon_smooth_patterns
;PURPOSE:
;     Compute, read and write smoothed universal modulation patterns
;CATEGORY:
;     HESSI Pixon image reconstruction
;CALLING SEQUENCE:
;     hsi_pixon_smooth_patterns,iobj,pixon_sizes,smoothed_patterns
;INPUTS:
;     iobj = image object
;     pixon_sizes = list of pixon_sizes
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;
;     /quiet = work quietly
;
;OUTPUTS:
;     smoothed_patterns = pointer array for smoothed patterns.  If this array
;                         has pointers to valid objects on input, they are
;                         freed before setting to new smoothed patterns
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 2000-Oct-20
;     T. Metcalf 2001-Aug-29 Changed mpd logic.
;     T. Metcalf 2003-Mar-18 Changed logic so that if a smoothed mod
;                            patt is not read in successfully, then it
;                            is computed.  Previously, if there was an
;                            error in the smoothed patt file, this
;                            routine would stop with an error.
;     K. Tolbert 2010-Jan-04 Fixed bug where detector 9 alone didn't work.
;                            Also changed repeat loop to simpler test for valid ptrs.
;     Richard Schwartz, 2011-Mar-02 Set sfile='' so won't use the smoothed modulation pattern
;                            files in SSWDB. They're the wrong dimension.
;     Richard Schwartz, 2015-Jan-20 Set sfile= removed unused comment blocks of old code
;     Richard Schwartz, 2015-Mar-20 Simplified and removed unused code
;     Richard Schwartz, 17-jun-2017 added tags to support Cartesian tag names
;-

pro hsi_pixon_smooth_patterns,iobj,pixon_sizes,smoothed_patterns, $
  tags = tags, quiet=quiet

   npixons = n_elements(pixon_sizes)
   ;Compute and save the smoothed modulation patterns

 mapptr = iobj->getdata(class_name='hsi_modul_pattern')
 
 smapptr = size(mapptr)
 ndet = smapptr[1]
 if n_elements(this_det) LE 0 then this_det = indgen(ndet)

 ndet = n_elements(this_det)
 if size(/tname, smoothed_patterns) eq 'POINTER' then ptr_free, smoothed_patterns
 smoothed_patterns = ptrarr(ndet,npixons)
 
 for iidet = 0L,ndet-1L do begin
    idet = this_det[iidet]
    
    if ptr_valid(mapptr[idet]) then begin
       modpat   = (*mapptr[idet])
       cart     = ~have_tag( modpat, 'ANNSEC_PHI_PTR' )
       ix       = get_tag_index( modpat, tags)
       cmap = *modpat.(ix[0]) 
       smap = *modpat.(ix[1]) 
       
      for ipixon=0L,npixons-1L do begin
        temp_pixonmap = cmap * 0.0 + pixon_sizes[ipixon]
        
        tsmoothed_cmap = hsi_pixon_local_smooth(cmap, temp_pixonmap, pixon_sizes, fft=0, cart = cart, modpat = modpat )
        tsmoothed_smap = hsi_pixon_local_smooth(smap, temp_pixonmap, pixon_sizes, fft=0, cart = cart, modpat = modpat )
        
        smoothed_patterns[iidet, ipixon] = $
          ptr_new( create_struct( tags[0], ptr_new(tsmoothed_cmap), $
            tags[1], ptr_new( tsmoothed_smap ) ) )
      endfor
    endif
 endfor
 end
