
pro hsi_pixon_bproj_copy_ptr, inptr, outptr, tags = tags;, free = free

  default, tags, ['cmap_ptr','smap_ptr']
  ix          = get_tag_index( inptr, tags )
  ox          = get_tag_index( outptr, tags )
  ;if keyword_set( free ) then for i = 0, 1 do ptr_free, outptr.( ox[i] )
  for i = 0, 1 do outptr.( ox[i] ) = inptr.( ix[i] )

end

;+
;PROJECT
;     HESSI
;NAME:
;     HSI_PIXON_BPROJ
;PURPOSE:
;     Get a back projection without any calibration effects which are present
;     in the GetBProj code.  This is used for the Pixon gradient calculations.
;CATEGORY:
;CALLING SEQUENCE:
;     bproj = hsi_pixon_bproj(vrate, dobj, iobj, det, harmonics)
;INPUTS:
;     vrate = data vector
;     dobj = data object
;     iobj = CE object
;     det = list of det's (from hsi_pixon_get_data.pro)
;     harmonics = list of harmonics's for each det
;                 (from hsi_pixon_get_data.pro) not used
;OPTIONAL INPUT PARAMETERS:
;KEYWORD PARAMETERS
;     First five parameters have been extracted from IOBJ to reduce object overhead
;      cbe_ptr = calib_eventlist pointer array
;      map_ptr = modpat pointer array
;      time_unit = multiplier on time_bin, number of binary microseconds
;      time_bin =  - number of time_units for each bin for each detector, 9 element vector
;      det_eff = cbe_det_eff extracted from object
;     /vanilla = Use the direct back projection, w/o all the normalizations
;                used in the object version.
;     /useunits = apply units to vrate.  Should match hsi_pixon_residuals.
;     /setunits = initialize units.
;     /nonorm = Do not use normalization from hsi_dirty_norm
;     /gaussian = use Gaussian statistics rather than Poisson statistics
;     /smoothpatts = Use smoothed mod patts in the back projection (slow)
;     diffres = resolution for differential smoothing.  Differentially
;               smoothed patterns are not stored and are recomputed at each
;               call.
;     /reset_smoothpatts = recompute smoothed patterns
;     /nocheck = do not waste time checking whether or not to recompute the
;                smoothed modulation patterns.  Careful with this one!
;                The /reset_smoothpatts keyword overrides this one.
;     pixon_sizes = vector of pixon sizes.  If set, recompute the smoothed
;                   patterns.
;     smpattwritedir = If new smoothed patterns are calculated and this
;                      keyword is set to a valid directory, then the
;                      new smoothed patterns will be saved in that directory - not used.
;OUTPUTS:
;     bproj = back projected image
;COMMON BLOCKS:
;SIDE EFFECTS:
;RESTRICTIONS:
;PROCEDURE:
;MODIFICATION HISTORY:
;     T. Metcalf 1999-Dec-08
;     T. Metcalf 2000-Feb-23 Added byte_cosine keyword.
;     T. Metcalf 2000-Sep-20 Complete overhaul to use the new annular sector
;                            mod patts.
;     T. Metcalf 2000-Oct-20 Moved pattern smoothing code to
;                            hsi_pixon_smooth_patterns.pro
;     T. Metcalf 2001-Aug-29 Changed mpd logic
;     T. Metcalf 2002-Nov-08 Included livetime in units and removed
;                            ndet factor kludge which was no longer
;                            required since I now use the
;                            /no_spatial_freq keyword.
;     T. Metcalf 2005-May-09 Added /no_rate_correct in call to bproj object
;     T. Metcalf 2005-Jul-01 Fixed typo, it is /norate_correct not
;                            /no_rate_correct.
;     K. Tolbert 2008-Dec-02 Fixed crash with time_range
;     R Schwartz 2014-Jan-02- make this more efficient by passing cbe_ptr (cbe pointers) from gof_func
;     R Schwartz 2015-Jan-16- Extensively edited to pass cbe_ptr, map_ptr, det_eff, time_unit, time_bins
;       directly into hsi_annsec_bproj and not the object to bypass object overhead. In retrospect could have edited the
;       hsi_bproj object to take those values directly and also avoid the object overhead but this path was more easily
;     R Schwartz 05-apr-2017, replaced all instances of "a2d" with "det", all commas followed by a space
;
;-

function hsi_pixon_bproj, vrate, dobj, iobj, det, harmonics, vanilla = vanilla, $
  setunits = setunits, useunits = useunits, $
  smoothpatts = smoothpatts, diffres = diffres, $
  pixon_sizes = pixon_sizes, pixonmap = pixonmap, $
  reset_smoothpatts = reset_smoothpatts, nonorm = nonorm, $
  nocheck = nocheck, smpattwritedir = smpattwritedir, $
  not_quiet = not_quiet, $
  cbe_ptr = cbe_ptr, $
  map_ptr = map_ptr, $
  time_unit = time_unit, $
  time_bin = time_bin, $
  det_eff = det_eff, $
  no_spatial_frequency_weight=no_spatial_frequency_weight, $
  _extra=_extra


  ; If this common block is changed, it must also be changed in
  ; hsi_pixon_free_mem.pro
  common hsi_pixon_bproj_private, units, smoothed_patterns, save_pixon_sizes, npixons, savempd
  common hsi_pixon_bproj_private2, old_ptr
  is_annsec = have_tag( *map_ptr[ (where( ptr_valid( map_ptr ) ))[0] ], 'annsec_center_ptr' )
  annsec_tags = ['cmap_ptr','smap_ptr']
  cart_tags   = ['cos_map1','sin_map1']
  tags        = is_annsec ? annsec_tags : cart_tags
  ;if is_struct( old_ptr ) && ptr_chk( old_ptr.(0) ) then  ptr_free, old_ptr.(0),old_ptr.(1)
  old_ptr =  create_struct( tags[0], ptr_new(), tags[1], ptr_new())





  if n_elements(diffres) NE 0 then usediffres = 1 else usediffres = 0
  check_smoothpatts = NOT keyword_set(nocheck) OR keyword_set(reset_smoothpatts)

  if keyword_set(smoothpatts) AND check_smoothpatts then begin
    ; Do we need to compute the smoothed patterns?
    if keyword_set(reset_smoothpatts) then recompute_smoothed_patts = 1 $
    else recompute_smoothed_patts = 0
    if n_elements(pixon_sizes) GT 0 then begin
      if n_elements(save_pixon_sizes) GT 0 then begin
        if n_elements(pixon_sizes) NE n_elements(save_pixon_sizes) then $
          recompute_smoothed_patts=1 $
        else if max(pixon_sizes-save_pixon_sizes) GT 0 then recompute_smoothed_patts=1
      endif else recompute_smoothed_patts=1
      if NOT recompute_smoothed_patts then begin
        if n_elements(savempd) LE 0 then begin
          recompute_smoothed_patts=1
        endif else begin
        endelse
      endif
      if recompute_smoothed_patts then begin
        hsi_pixon_smooth_patterns, iobj, $
          pixon_sizes, $
          smoothed_patterns, $
          tags = tags, $
          quiet = 1-keyword_set(not_quiet)
        save_pixon_sizes = pixon_sizes
      endif
    endif else message, /info, 'WARNING: smoothpatts set, but pixon_sizes not passed in.  NO SMOOTHING'
  endif

  if have_tag( _extra, 'cbe_ptr') then cbe_ptr = _extra.cbe_ptr
  cbe_ptr = max( ptr_valid( cbe_ptr )) ? cbe_ptr : iobj->GetData(class_name='hsi_calib_eventlist')
  ;cbe_ptr = iobj->GetData(class_name='hsi_calib_eventlist')
  scelist = size(cbe_ptr)
  det_index_mask= ptr_valid( cbe_ptr ) ;iobj->get(/det_index_mask)
  test = where(det_index_mask, ndetectors)
  if n_elements(units) LE 0 or keyword_set(setunits) then begin
    message, /info, 'Resetting units'
    if n_elements(units) GT 0 then begin
      for i=0L, n_elements(units)-1L do ptr_free, units[i]
    endif
    units = ptrarr(scelist[1])
    time_bin_sec = n_elements( time_bin ) ge 1 ? time_bin/2.0^20 : float(iobj->get(/time_bin_def)*iobj->get(/time_bin_min))/2L^20
    for i=0, scelist[1]-1 do begin  ; Is this the right order???
      j = 0 ; no harmonics index in the new scheme
      if ptr_valid(cbe_ptr[i, j]) then begin
        qtrans = (*cbe_ptr[i, j]).gridtran
        livetime = (*cbe_ptr[i, j]).livetime
        flux_var = (*cbe_ptr[i, j]).flux_var
        this_det_eff = (det_eff.rel)[i] ;((iobj->get(/cbe_det_eff)).rel)[i MOD 9]
        ; These units seem upside down, but they are only used for
        ; the gradient calculation and the r2s array which is passed
        ; in at the data has units of 1/fobs.  These units must be
        ; consistent with those in hsi_pixon_residuals and must equal
        ; whatever is in hsi_pixon_residuals multiplied by
        ; time_bin[i MOD 9]*qtrans
        units[i, j] = $
          ptr_new(time_bin_sec[i MOD 9] * qtrans * livetime)  ; image units ph/coll/sec
      endif
    endfor
  endif

  ;bproj = fltarr(nx, ny)

  if keyword_set(smoothpatts) then npixons = n_elements(save_pixon_sizes) $
  else npixons = 1L
  ;map_ptr = iobj->getdata(class_name='hsi_modul_pattern')
  map_ptr = max( ptr_valid( map_ptr )) ? map_ptr : iobj->GetData(class_name='hsi_modul_pattern')
  for ipixon = 0L, npixons-1L do begin
    if keyword_set(smoothpatts) then begin
      ssmask = where(abs((pixonmap-save_pixon_sizes[ipixon])/save_pixon_sizes[ipixon]) LE 0.01, nssmask)
    endif else begin
      nssmask = 1L
    endelse
    if nssmask GT 0 then begin
      i1 = 0L
      for i=0, n_elements(det)-1 do begin
        ;nharmonics = iobj->get(/max_harm)
        ;j=0  ; no harmonic index in the new scheme
        mpx          = get_tag_index( *map_ptr[det[i]], tags )
        sv_ptr = [ ( *map_ptr[ det[i] ] ).(mpx[0]), ( *map_ptr[ det[i] ] ).(mpx[1]) ]
        if keyword_set(smoothpatts) then begin
          hsi_pixon_bproj_copy_ptr, *map_ptr[det[i]], old_ptr, tags = tags

          ; Set smoothed pointers
          if NOT usediffres then begin
            hsi_pixon_bproj_copy_ptr, *smoothed_patterns[det[i], ipixon], *map_ptr[det[i]], tags = tags
          endif else begin
            default, subtract_patterns, 1 ;just subtract appropriate smoothed patterns
            ;don't do any more fft convolution in smooth_patterns
            hsi_pixon_smooth_patterns_diff, iobj, $
              save_pixon_sizes[ipixon], $
              diffsmoothed_patterns, $
              this_det = det[i], $
              tags = tags, $
              ;this_harm = 0, $
              diffresindex = diffres, $
              diffresvalue = save_pixon_sizes[diffres], $
              ipixon = ipixon, $
              subtract_patterns = subtract_patterns, $
              /quiet
            if keyword_set(not_quiet) then begin
              if i eq 0 then begin
                print, format='($, "|.")'
              endif else begin
                print, format='($, ".")'
              endelse
            endif
            diffsmooth = is_struct( diffsmoothed_patterns[0, 0] ) ? diffsmoothed_patterns[0, 0] : *diffsmoothed_patterns[0, 0]
            hsi_pixon_bproj_copy_ptr, diffsmooth, (*map_ptr[det[i]]), tags = tags
          endelse
          ;
        endif
        ndah = n_elements(*dobj[det[i]])
        i2 = i1 + ndah -1L

        rate = vrate[i1:i2]
        if keyword_set(useunits) then begin
          rate = rate*(*units[det[i]])
          if n_elements((*units[det[i]])) NE i2-i1+1 then begin
            message, /info, 'WARNING: problem with unit array'
          endif
        endif
        use_flatfield = ~keyword_set(vanilla)
        btemp = is_annsec ? hsi_annsec_bproj( $
          USE_RATE = 0, $ ;/NORATE_CORRECT,
          this_det_index = det[i], $
          data_ptr=rate, flatfield= use_flatfield, $
          det_eff = det_eff.rel, $
          cbe_ptr = cbe_ptr, $
          map_ptr = map_ptr) : $
          hsi_cart_bproj_1det( *cbe_ptr[ det[i] ],*map_ptr[ det[i] ], $
          rate, det_eff=det_eff.rel[ det[i] ], flatfield=use_flatfield)
        if ~keyword_set(nonorm) && (use_flatfield eq 0) then $
          btemp = btemp / hsi_dirty_norm(iobj, /polar)
        if usediffres then begin
          btemp = btemp - total(rate)
        endif
        i1 = i1 + ndah
        if keyword_set(smoothpatts) then begin
          if ~exist( bproj ) then bproj = btemp * 0.0
          bproj[ssmask] += btemp[ssmask]
          if usediffres then begin
            ; Won't be used again, so free the memory
            mp = *map_ptr[det[i]]
            ;if is_struct( old_ptr ) && ptr_chk( old_ptr.(0) ) then  ptr_free, old_ptr.(0),old_ptr.(1)
            mpx          = get_tag_index( mp, tags )
            if ptr_valid( mp.(mpx[0])) then begin
              if mp.(mpx[0]) ne sv_ptr[0] then ptr_free, mp.(mpx[0])
              if mp.(mpx[1]) ne sv_ptr[1] then ptr_free, mp.(mpx[1])
            endif

          endif
          ; Reset pointers to unsmoothed patterns
          hsi_pixon_bproj_copy_ptr, old_ptr, *map_ptr[det[i]], tags = tags

        endif else begin
          bproj = bproj + btemp
        endelse
      endfor
      if i2 NE n_elements(vrate)-1 then message, 'vrate had the wrong dimension'
    endif
  endfor

  return, bproj

end


