;+
; :Description:
;    Describe the procedure.
;
; :Params:
;    image_obj - input, hessi object with modul_pattern upstream
;    x - image pixel coord in arcsec
;    y - image pixel coord in arcsec
; :Keywords
;    noxyoffset - 0, 1, if set then just raw pixel offsets from image center without xyoffset, default 0
;
;
;
; :Author: raschwar, 5-jun-2017
;-
pro hsi_cart_coord, image_obj, x, y, noxyoffset = noxyoffset
  
  default, noxyoffset, 0
  xyoffset = noxyoffset ? fltarr(2) : image_obj->Get(/xyoffset)
  pixel_size = image_obj->Get(/pixel_size)
  map_dim = image_obj->Get(/image_dim)
  xy = pixel_coord( map_dim )
  x = reform( xy[0,*], map_dim ) * pixel_size[0] + xyoffset[0]
  y = reform( xy[1,*], map_dim ) * pixel_size[1] + xyoffset[1]
end