;+
; PROJECT:
;   HESSI
; NAME:
;   HSI_CART_BPROJ_WEIGHT
;
; PURPOSE:
;   This function corrects back projections with the weighting maps. Used only
;   one bproj map at a time for a single det_index and harmonic.
;
; CATEGORY:
;   HESSI, UTIL, IMAGE
;
; CALLING SEQUENCE:
;   corrected_bproj = hsi_cart_bproj_weight(bproj, summed_counts, wmap_ptr, cbe_ptr)
;
; CALLS:
;  
;
; INPUTS:
;   BPROJ   - result of unweighted call to hsi_annsec_bproj, i.e. count rate times modpat.
;   Summed_counts - Summed counts, take from keyword in hsi_annsec_bproj for this det_index
;     and harmonic.
;       Wmap_ptr - weight map pointer for this det_index and this harmonick
;
;
; OPTIONAL INPUTS:
;   none
;
; OUTPUTS:
;       none explicit, only through commons;
;
; OPTIONAL OUTPUTS:
;   none
;
; KEYWORDS:
;
; COMMON BLOCKS:
;   none
;
; SIDE EFFECTS:
;   none
;
; RESTRICTIONS:
;   none
;
; PROCEDURE:
;   Implements procedure in http://hesperia.gsfc.nasa.gov/~schmahl/bproj_correction/corrbproj_gh.html
;
; MODIFICATION HISTORY:
;   26-may-2017, RAS, based on hsi_annsec_bproj_weight
;
;-
function hsi_cart_bproj_weight, bproj, summed_counts, wmap_ptr, cbe, $
    det_eff=det_eff, use_rate=use_rate

cc = ptr_chk( cbe ) ? *cbe : cbe
wmap = ptr_chk( wmap_ptr ) ? *wmap_ptr : wmap_ptr

this_det_eff = exist(det_eff)? det_eff : 1.0
ndim = (size(/dim, wmap))[2] ;26-may-2017, only have ndim eq 2 option for now
tweight = 1- cc.gap
default, use_rate, 0
if use_rate then tweight = tweight * cc.livetime
denom2 = ndim eq 2 ? (wmap)[*,*,0]^2 : (wmap)[*,*,2]^2


out = f_div( bproj-summed_counts * (wmap)[*,*,0], $
    total(cc.gridtran*tweight)/total(tweight) * this_det_eff* $
    ((wmap)[*,*,1]- denom2 ))


return, out
 end