;+
; PROJECT:
;  HESSI
; NAME:
;  HSI_cart_bproj_1det
;
; PURPOSE:
;  Returns the back-projection of the hessi calibrated eventlist.
;
; CATEGORY:
;  HESSI, UTIL
;
; CALLING SEQUENCE:
;  map = hsi_cart_bproj_1det( data, cpatt_ptr [,use_rate = use_rate] )
;
;;
;
; CALLS:
;  none
;
; INPUTS:
;    data - calib_eventlist pointer or structure containing the "count" field or flat array of counts
;    cpatt_ptr - cartesian modulation pattern structure or pointer of same
;     
;
; OPTIONAL INPUTS:
;
;
; OUTPUTS:
;    Returns the map as a pointer ( if SUM eq 0 ) or as a 2-d image in polar coordinates.
;
; OPTIONAL OUTPUTS:
;  none
;
; KEYWORDS:

;  COUNTS_SUMMED - sum of livetime corrected counts. Returned as a 9 elem array
;  unles this_det_index is used, when it comes back as a single number.
;  USE_RATE- use count rate not count to for back-projection weighting.
;
;
; COMMON BLOCKS:
;  none
;
; SIDE EFFECTS:
;  none
;
; RESTRICTIONS:
;  should only be called from hsi_cart_bproj!!!
;
; PROCEDURE:
;  none
;
; MODIFICATION HISTORY:
;
; 14-may-2017, ras, based on hsi_annsec_bproj_1det and hsi_cart_bproj
;-
function hsi_cart_bproj_1det, cc, cmpat, data, $ ;cbe is a pointer or pointer array
  no_tot_vrate = no_tot_vrate, counts_summed  = counts_summed, $
  use_rate = use_rate, $
  det_eff = this_det_eff, flatfield = flatfield
 

   out = hsi_cart_bproj_struct( cc, cmpat, data, $
    use_rate = use_rate, $
    no_tot_vrate = no_tot_vrate, counts_summed = counts_summed, _extra = _extra )
  if keyword_set( flatfield ) then begin
     
    out = hsi_cart_bproj_weight( out, counts_summed, cmpat.weight_map_ptr, cc, $
      use_rate = use_rate, det_eff = this_det_eff )
  endif

  return, reform( out, cmpat.image_dim )
end

