;+
; Project:
; Gen/Image
; Name:
; VIS_BPROJ
; Purpose:
; This function makes and optionally displays a backprojection map from a visibility bag
; Calling Sequence:
; result = vis_bpmap( visin,time=time,_EXTRA=extra,BP_FOV=bp_fov, PIXEL=pixel, MAP=map, $
;     QUIET=quiet, PEAKXY=peakxy, NOPLOT=noplot, EDGEFLAG=edgeflag,  $
;     label=label, UNIFORM_WEIGHTING=uniform_weighting, spatial_freqency_weight =spatial_frequency_weight, $
;     data_only = data_only, $
;     LOOPSTYLE = loopstyle, $
;     _EXTRA=_extra)
; Inputs:
; Visin - visibility bag.  See {hsi_vis} for a compliant structure, must have
;   fields, isc, u, v, and obsvis
;   IDL> help, {hsi_vis},/st
;   ** Structure HSI_VIS, 15 tags, length=104, data length=94:
;   ISC             INT              0
;   HARM            INT              0
;   ERANGE          FLOAT     Array[2]
;   TRANGE          DOUBLE    Array[2]
;   U               FLOAT          0.000000
;   V               FLOAT          0.000000
;   OBSVIS          COMPLEX   (     0.000000,     0.000000)
;   TOTFLUX         FLOAT          0.000000
;   SIGAMP          FLOAT          0.000000
;   CHI2            FLOAT          0.000000
;   XYOFFSET        FLOAT     Array[2]
;   TYPE            STRING    ''
;   UNITS           STRING    ''
;   ATTEN_STATE     INT              0
;   COUNT           FLOAT          0.000000
; Outputs:
; Map - flat array back projection map or map structure if DATA_ONLY is set to 0
;   Overall normalization is arbitrary.
; Keywords
; image_dim - int scalar, defaults to 65
; pixel_size - float scalar, defaults to 1.0 arcsecond
; /QUIET suppresses  output to the screen, default is 1
; /NOPLOT suppresses plot output, default is 1
; DATA_ONLY - default is 1, if set, return a flat array, otherwise a map structure
; PEAKXY = 2-element vector to receive location of |map| maximum
; EDGEFLAG is set to -1 if peak map pixel is at one edge of the map.  In that case, peakxy is not interpolated
; LABEL = plot title (Default is current time.)
; UNIFORM_WEIGHTING - 0/1 default is 0,
;   changes subcollimator weighting from default (NATURAL) to UNIFORM
;   setting to 0 uses NATURAL weighting, either sets SPATIAL_FREQUENCY_WEIGHT
; BP_FOV = field of view (arcsec) defaults to image_dim * pixel_size squared
; SPATIAL_FREQUENCY_WEIGHT - weighting for each collimator, set by UNIFORM_WEIGHTING if used
; The number of weights should either equal the number of unique sub-collimators or the number of visibilities
;   Also, the default RHESSI case is supported, passing 9 weights and the ones for each sc are selected from those
; LOOPSTYLE- for debugging, if set supports original style of bp computation in hsi_vis_bpmap
; LIVETIME_WEIGHTING - default, 0 if set include livetime and weighting to compensate when sc's have more rotation bins
; History
; 26-Dec-2016, ras, wrapper around vis_bpmap procedure
;-
function vis_bproj, vis, $
image_dim=image_dim, pixel_size=pixel_size,$ 
spatial_freqency_weight = spatial_frequency_weight, info=info, _ref_extra=extra
default, pixel_size, 1.0
default, image_dim, 65
bp_fov = image_dim[0] * pixel_size[0]

   vis_bpmap, vis,  MAP = map, $
    BP_FOV = bp_fov, PIXEL = pixel_size, $
    spatial_freqency_weight = spatial_frequency_weight, $
    info = info, loopstyle = 0b, $
    /data_only, $
    _EXTRA = extra
    
return, map
end