FUNCTION PXN_PSF_ARR, Scales, binup = binup
; +
; PSF Generation- Parabolic version
;
; Produce a positive, parabolic PSF of height 1 and radius scales[i]
; using the array distances^2 from the center of the FOV determined by the 
; maximum of scales 
; Input parameters:
; Scales - size in pixels for psf, an array of real positive numbers
;   keep in mind the array used for computations is binup * max(scales) squared
; BINUP - multiplying factor to increase the resolution. result has binup removed via rebin
; 
; History:
; 22-oct-2013, richard.schwartz@nasa.gov, based on a routine by
; R. K. Pina and R. C. Puetter.
;-
default, binup, 11
binup = binup / 2 * 2 + 1
nscales = n_elements( scales )
mscale  = long(max( scales )) * 2 + 1 
out = fltarr( [mscale + fltarr(2), nscales] ) 
dist2 = reform( /over, total( pixel_coord( [mscale, mscale]*1L * binup )^2, 1), fltarr(2)+mscale*binup)

for i = 0, nscales - 1 do $
  out[ 0, 0, i] = rebin( pxn_psf( dist2, 1.0, scales[i] * binup), mscale + fltarr(2)  ) 
return, out
END
