;+
;
;Take a psf centered on its map and add it centered on coordinates xy onto map
;Both map and psf should have odd numbers of elements for rows and columns so the
;psf can be shifted and not interpolated. Won't work with even elements
;-
function psf_add, xy, map, psf, threshold = threshold, error=error

default, threshold, 0.0
mdim = size(map, /dimension)
pdim = size(psf, /dimension)
error = 0
if total( ([mdim, pdim] -1) mod 2 ) ne 0 then begin
	message,/info, 'map and psf must have odd dimensioned rows and columns'
	error = 1
	return, -1
	end

;so xyij gives the pixel where we want to put the psf
;right now it is at
psfij = long( pdim/2 )
mapij = long( mdim/2 )
;shiftij = psfij - xyij
;get ij for all psf gt threshold
z = where( psf gt threshold, nz )
zij = get_ij( z, pdim[0] )
;now in psf centered coordinates
;get where it's going in the same coordinates
xyij = n_elements( xy ) eq 1 ? get_ij( xy, mdim[0]) : xy

;Add xyij to zij
zij +=  rebin( xyij - psfij, 2, nz )
;convert those to array coordinates
valid = where( zij[0,*] ge 0 and zij[0,*] lt mdim[0] and $
	zij[1,*] ge 0 and zij[1,*] lt mdim[1], nvalid)
zij = zij[*, valid]
z   = z[valid]
zij = zij[1,*] * mdim[0] + zij[0,*]
map[zij] += psf[z]
return, map
end
